<?php if ( ! class_exists( 'GhostPool_Hub_Fields' ) ) {

	class GhostPool_Hub_Fields {

		public function __construct() {
			add_action( 'init', array( &$this, 'ghostpool_hub_fields' ) );
		}
			
		public function ghostpool_hub_fields() {
			
			if ( function_exists( 'ghostpool_option' ) && ghostpool_option( 'hub_fields' ) ) {
			
				$char_table = array();

				// Support for foreign characters
				if ( function_exists( 'ghostpool_hub_field_characters' ) ) {
					$char_table = ghostpool_hub_field_characters();
				}	
				
				foreach( ghostpool_option( 'hub_fields' ) as $hub_field ) {
	
					$hub_field_slug = strtr( $hub_field, $char_table );
					if ( function_exists( 'iconv' ) ) {
						$hub_field_slug = iconv( 'UTF-8', 'UTF-8//TRANSLIT//IGNORE', $hub_field_slug );
					}
					$hub_field_slug = sanitize_title( $hub_field_slug );
					$hub_field_slug = substr( $hub_field_slug, 0, 32 );
					
					register_taxonomy( $hub_field_slug, array( 'post', 'page' ), array(
						'show_in_rest' => true,
						'labels' => array(
							'name' => $hub_field,
							'singular_name' => $hub_field,
							'all_items' => esc_html__( 'All ', 'huber-plugin' ) . $hub_field,
							'add_new' => _x( 'Add New', 'hub', 'huber-plugin' ),
							'add_new' => _x( 'Add New', 'hub', 'huber-plugin' ),
							'add_new_item' => esc_html__( 'Add New ', 'huber-plugin' ) . $hub_field,
							'edit_item' => esc_html__( 'Edit ', 'huber-plugin' ) . $hub_field,
							'new_item' => esc_html__( 'New ', 'huber-plugin' ) . $hub_field,
							'view_item' => esc_html__( 'View ', 'huber-plugin' ) . $hub_field,
							'search_items' => esc_html__( 'Search ', 'huber-plugin' ) . $hub_field,
							'menu_name' => $hub_field,
						),
					) );
					
					register_taxonomy_for_object_type( $hub_field_slug, array( 'post', 'page' ) );

				}
				
			}

		}

	}

}

?>