<?php 

if ( ! function_exists( 'ghostpool_blog' ) ) {

	function ghostpool_blog( $atts, $content = null ) {	
		
		extract( shortcode_atts( array(
			'widget_title' => '',			
			'cats' => '',
			'hub_fields' => '',
			'page_ids' => '',
			'post_types' => 'post',
			'post_association' => 'disabled',		
			'ranking' => 'gp-no-ranking',	
			'format' => 'gp-blog-list',
			'orderby' => 'newest',	
			'release_date_from' => '',
			'release_date_to' => '',
			'per_page' => '9',
			'offset' => '',
			'image_size_standard' => 'default',
			'image_size_hub' => 'default',
			'image_size_review' => 'default',
			'image_size_preview' => 'default',
			'content_display' => 'excerpt',
			'excerpt_length' => '160',
			'meta_release_date' => '',
			'meta_author' => '',
			'meta_date' => '',
			'meta_views' => '',
			'meta_likes' => '',
			'meta_followers' => '',
			'meta_comment_count' => '',
			'meta_cats' => '',
			'meta_tags' => '',
			'meta_hub_fields' => '',
			'meta_site_rating' => '',
			'meta_user_rating' => '',
			'filter_cats' => '',
			'filter_date' => '',
			'filter_title' => '',					
			'filter_comment_count' => '',
			'filter_views' => '',
			'filter_likes' => '',
			'filter_release_date' => '',
			'filter_release_date_asc' => '',
			'filter_site_rating' => '',
			'filter_user_rating' => '',
			'filter_cat_id' => '',
			'read_more_link' => 'disabled',
			'page_arrows' => 'disabled',
			'pagination' => 'page-numbers',
			'see_all' => 'disabled',
			'see_all_link' => '',
			'see_all_text' => esc_html__( 'See All Items', 'huber-plugin' ),
			'classes' => '',
			'icon_color' => '#fff',	
			'icon_bg_color' => '#fe4a49',		
			'icon' => '',
			'title_color' => '',
			'post_title_color' => '',
			'post_title_hover_color' => '',
			'post_link_color' => '',
			'post_link_hover_color' => '',
			'post_text_color' => '',
			'meta_text_color' => '',
			'ranking_bg_color' => '',
			'ranking_text_color' => '',
		), $atts ) );

		// Load filter variables
		$type['cats'] = $filter_cats;
		$type['date'] = $filter_date;
		$type['title'] = $filter_title;
		$type['comment_count'] = $filter_comment_count;
		$type['views'] = $filter_views;
		$type['likes'] = $filter_likes;
		$type['release_date'] = $filter_release_date;
		$type['release_date_asc'] = $filter_release_date_asc;
		$type['site_rating'] = $filter_site_rating;
		$type['user_rating'] = $filter_user_rating;
						
		// Unique Name	
		STATIC $i = 0;
		$i++;
		$name = 'gp_blog_wrapper_' . $i;
		
		// Get post or hub association ID
		$a_post_id = get_hub_association_id( get_the_ID() );

		// Add CSS styling to header
		ghostpool_shortcode_styling( $name, $title_color, $post_title_color, $post_title_hover_color, $post_link_color, $post_link_hover_color, $post_text_color, $meta_text_color, '', $ranking_bg_color, $ranking_text_color );
				
		// Post counter
		$counter = 1;
		
		// Ranking counter;
		$ranking_counter = 1;
																	
		$args = array(
			'post_status'         => 'publish',
			'post_type'     	  => $post_types ? explode( ',', $post_types ) : '',
			'post__in'      	  => $page_ids ? explode( ',', $page_ids ) : '',
			ghostpool_cats( $cats, 'param' ) => ghostpool_cats( $cats, 'variables' ),
			'tax_query'           => ghostpool_tax( $hub_fields ),
			'orderby' 		      => ghostpool_orderby( $orderby, 'orderby' ),
			'order' 		      => ghostpool_orderby( $orderby, 'order' ),	
			'meta_key' 		      => ghostpool_orderby( $orderby, 'meta_key' ),	
			'meta_query' 		  => ghostpool_orderby( $orderby, 'meta_query', $release_date_from, $release_date_to, $post_association, get_hub_association_id( get_the_ID() ) ),
			'posts_per_page'      => $per_page,
			'offset' 		      => $offset,	
			'paged'          	  => $pagination != 'disabled' ? ghostpool_paged() : 1,
			'ignore_sticky_posts' => 1,
		);
		
		$args = apply_filters( 'ghostpool_blog_element_query', $args, $post_types, $page_ids, $cats, $hub_fields, $orderby, $release_date_from, $release_date_to, $post_association, $per_page, $offset );
		
		ob_start(); $gp_query = new WP_Query( $args );  ?>
			
		<?php if ( $gp_query->have_posts() ) : ?>

			<div id="<?php echo sanitize_html_class( $name ); ?>" class="gp-blog-wrapper gp-vc-element <?php echo sanitize_html_class( $format ); ?> <?php echo sanitize_html_class( $ranking ); ?> <?php echo esc_attr( $classes ); ?>" data-type="blog" data-postid="<?php echo $a_post_id; ?>" data-cats="<?php echo esc_attr( $cats ); ?>" data-hubfields="<?php echo esc_attr( $hub_fields ); ?>" data-posttypes="<?php echo esc_attr( $post_types ); ?>" data-postassociation="<?php echo esc_attr( $post_association ); ?>" data-ranking="<?php echo esc_attr( $ranking ); ?>" data-format="<?php echo esc_attr(  $format ); ?>" data-orderby="<?php echo esc_attr( $orderby ); ?>" data-releasedatefrom="<?php echo esc_attr( $release_date_from ); ?>" data-releasedateto="<?php echo esc_attr( $release_date_to ); ?>" data-perpage="<?php echo absint( $per_page ); ?>" data-offset="<?php echo esc_attr( $offset ); ?>" data-imagesizestandard="<?php echo esc_attr( $image_size_standard ); ?>" data-imagesizehub="<?php echo esc_attr( $image_size_hub ); ?>" data-imagesizereview="<?php echo esc_attr( $image_size_review ); ?>" data-imagesizepreview="<?php echo esc_attr( $image_size_preview ); ?>" data-contentdisplay="<?php echo esc_attr( $content_display ); ?>" data-excerptlength="<?php echo absint( $excerpt_length ); ?>" data-metareleasedate="<?php echo esc_attr( $meta_release_date ); ?>" data-metaauthor="<?php echo esc_attr( $meta_author ); ?>" data-metadate="<?php echo esc_attr( $meta_date ); ?>" data-metacommentcount="<?php echo esc_attr( $meta_comment_count ); ?>" data-metaviews="<?php echo esc_attr( $meta_views ); ?>" data-metalikes="<?php echo esc_attr( $meta_likes ); ?>" data-metafollowers="<?php echo esc_attr( $meta_followers ); ?>" data-metacats="<?php echo esc_attr( $meta_cats ); ?>" data-metatags="<?php echo esc_attr( $meta_tags ); ?>" data-metahubfields="<?php echo esc_attr( $meta_hub_fields ); ?>" data-metasiterating="<?php echo esc_attr( $meta_site_rating ); ?>" data-metauserrating="<?php echo esc_attr( $meta_user_rating ); ?>" data-readmorelink="<?php echo esc_attr( $read_more_link ); ?>" data-pagearrows="<?php echo esc_attr( $page_arrows ); ?>" data-pagination="<?php echo esc_attr( $pagination ); ?>">
			
				<div class="gp-widget-title">
				
					<?php if ( $icon ) { ?><i class="gp-element-icon fa <?php echo sanitize_html_class( $icon ); ?>" style="<?php if ( $icon_color ) { ?>color: <?php echo esc_attr( $icon_color ); ?>;<?php } ?><?php if ( $icon_bg_color ) { ?>background-color: <?php echo esc_attr( $icon_bg_color ); ?>;<?php } ?>"></i><?php } ?>
				
					<?php if ( $widget_title ) { ?><h3 class="widgettitle"><?php echo esc_attr( $widget_title ); ?></h3><?php } ?>					
																										
					<?php ghostpool_filter(
						$type,
						$filter_cat_id,
						$orderby,
						$pagination,
						false
					); ?>
		
				</div>
				
				<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">

					<?php if ( $page_arrows == 'enabled' ) { ?>
						<div class="gp-pagination gp-standard-pagination gp-pagination-arrows">
							<?php echo ghostpool_pagination_arrows( $gp_query->max_num_pages ); ?>
						</div>
					<?php } ?>
				
					<div class="gp-section-loop-inner">							

						<?php if ( $format == 'gp-blog-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>
					
						<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>
							
							<?php if ( $format == 'gp-blog-minimal' ) { ?>
							
								<?php if ( function_exists( 'ghostpool_post_loop_minimal' ) ) { ghostpool_post_loop_minimal( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link, $counter, $ranking, $ranking_counter, $per_page ); } ?>
							
							<?php } else { ?>

								<?php if ( function_exists( 'ghostpool_post_loop' ) ) { ghostpool_post_loop( $format, $image_size_standard, $image_size_hub, $image_size_review, $image_size_preview, $content_display, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link, $counter, $ranking, $ranking_counter ); } ?>
							
							<?php } ?>
							
						<?php $counter++; $ranking_counter++; endwhile; ?>
						
					</div>

					<?php echo ghostpool_pagination( $gp_query->max_num_pages, $pagination ); ?>
					
				</div>	
																		
				<?php if ( $see_all == 'enabled' ) { ?>
					<a href="<?php echo esc_url( $see_all_link ); ?>" class="gp-see-all-link button"><?php echo esc_attr( $see_all_text ); ?></a>
				<?php } ?>
							
			</div>

			<?php if ( $pagination == 'load-more' ) { ?>
				<script>
				jQuery( document ).ready( function( $ ) {	
					'use strict';
					if ( $( 'body' ).hasClass( 'gp-theme' ) ) {
						$( '#<?php echo sanitize_html_class( $name ); ?> .gp-section-loop-inner' ).infinitescroll({
							debug: false,
							loading: {
								finishedMsg: '',
								img: '<?php echo get_template_directory_uri(); ?>/lib/framework/images/blank.gif',
								msgText: '',
								speed: 'fast',
							},
							nextSelector: '#<?php echo sanitize_html_class( $name ); ?> ul.page-numbers a',
							navSelector: '#<?php echo sanitize_html_class( $name ); ?> .gp-pagination',
							itemSelector: '#<?php echo sanitize_html_class( $name ); ?> section',
							maxPage: <?php echo absint( $gp_query->max_num_pages ); ?>,
							extraScrollPx: 0,
							bufferPx: 0
						}, function( json, opts ) {
							if ( opts.state.currPage == <?php echo $gp_query->max_num_pages; ?> ) {
								$( '#<?php echo sanitize_html_class( $name ); ?> .gp-load-more' ).remove();
							}
						});
						$( '#<?php echo sanitize_html_class( $name ); ?> .gp-section-loop-inner' ).infinitescroll( 'unbind' );
						$( '#<?php echo sanitize_html_class( $name ); ?> .gp-load-more-button' ).click( function() {
							 $( '#<?php echo sanitize_html_class( $name ); ?> .gp-section-loop-inner' ).infinitescroll( 'retrieve' );
							 return false;
						});	
					}
				});
				</script>
			<?php } ?>
			
		<?php endif; wp_reset_postdata(); ?>	
									
		<?php

		$output_string = ob_get_contents();
		ob_end_clean();
		return $output_string;

	}

}

add_shortcode( 'blog', 'ghostpool_blog' );
	
?>