<?php
		
if ( ! function_exists( 'ghostpool_carousel' ) ) {

	function ghostpool_carousel( $atts, $content = null ) {	
		
		extract( shortcode_atts( array(
			'widget_title' => '',	
			'cats' => '',
			'hub_fields' => '',
			'page_ids' => '',
			'post_types' => 'post',
			'post_association' => 'disabled',
			'orderby' => 'newest',	
			'release_date_from' => '',
			'release_date_to' => '',
			'items_in_view' => '3',
			'per_page' => '12',
			'offset' => '',	
			'meta_site_rating' => '',
			'meta_user_rating' => '',	
			'slider_speed' => '0',
			'animation_speed' => '0.6',
			'buttons' => 'enabled',
			'arrows' => 'enabled',
			'classes' => '',
			'icon_color' => '#fff',	
			'icon_bg_color' => '#fe4a49',
			'icon' => '',
			'title_color' => '',
			'post_title_color' => '',
			'post_title_hover_color' => '',
			'post_link_color' => '',
			'post_link_hover_color' => '',
			'post_text_color' => '',
			'meta_text_color' => '',
		), $atts ) );
	
		// Unique Name	
		STATIC $i = 0;
		$i++;
		$name = 'gp_carousel_wrapper_' . $i;
		
		// Add CSS styling to header
		ghostpool_shortcode_styling( $name, $title_color, $post_title_color, $post_title_hover_color, $post_link_color, $post_link_hover_color, $post_text_color, $meta_text_color );
		
		$args = array(
			'post_status'    => 'publish',
			'post_type'      => $post_types ? explode( ',', $post_types ) : '',
			'post__in'       => $page_ids ? explode( ',', $page_ids ) : '',
			ghostpool_cats( $cats, 'param' ) => ghostpool_cats( $cats, 'variables' ),
			'tax_query'      => ghostpool_tax( $hub_fields ),
			'orderby'        => ghostpool_orderby( $orderby, 'orderby' ),
			'order'          => ghostpool_orderby( $orderby, 'order' ),
			'meta_key'       => ghostpool_orderby( $orderby, 'meta_key' ),
			'meta_query' 	 => ghostpool_orderby( $orderby, 'meta_query', $release_date_from, $release_date_to, $post_association, get_hub_association_id( get_the_ID() ) ),
			'posts_per_page' => $per_page,		
			'offset' 		 => $offset,
			'paged'			 => 1,
			'no_found_rows'	 => true,
			'ignore_sticky_posts' => 1,
		);
		
		$args = apply_filters( 'ghostpool_carousel_element_query', $args, $post_types, $page_ids, $cats, $hub_fields, $orderby, $release_date_from, $release_date_to, $per_page, $offset );

		ob_start(); $gp_query = new WP_Query( $args ); ?>

		<?php if ( $gp_query->have_posts() ) : ?>
			
			<div id="<?php echo sanitize_html_class( $name ); ?>" class="gp-carousel-wrapper gp-vc-element gp-slider <?php echo esc_attr( $classes ); ?>">
			
				<div class="gp-widget-title">
					<?php if ( $icon ) { ?><i class="gp-element-icon fa <?php echo sanitize_html_class( $icon ); ?>" style="<?php if ( $icon_color ) { ?>color: <?php echo esc_attr( $icon_color ); ?>;<?php } ?><?php if ( $icon_bg_color ) { ?>background-color: <?php echo esc_attr( $icon_bg_color ); ?>;<?php } ?>"></i><?php } ?>
					<?php if ( $widget_title ) { ?><h3 class="widgettitle"><?php echo esc_attr( $widget_title ); ?></h3><?php } ?>
				</div>
				
				<ul class="slides">

					<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); ?>
			
						<li>			

							<section <?php post_class( 'gp-post-item' ); ?> itemscope itemtype="http://schema.org/Blog">
						
								<?php if ( has_post_thumbnail() ) { ?>
						
									<div class="gp-post-thumbnail gp-loop-featured">
										<a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>>
											<?php the_post_thumbnail( 'ghostpool-col-category-image' ); ?>
											<span class="gp-loop-ratings">							
												<?php if ( $meta_site_rating == '1' ) {
													get_template_part( 'lib/sections/taxonomies/loop-site-rating' ); 
												} 	
												if ( $meta_user_rating == '1' ) {
													get_template_part( 'lib/sections/taxonomies/loop-user-rating' ); 
												} ?>
											</span>
										</a>				
									</div>
						
								<?php } elseif ( get_post_format() != '0' && get_post_format() != 'gallery' ) { ?>

									<div class="gp-loop-featured">
										<?php get_template_part( 'lib/sections/loop/taxonomies/', get_post_format() ); ?>
									</div>
									
								<?php } ?>
								
								<?php if ( get_post_format() != 'quote' OR has_post_thumbnail() ) { ?>

									<div class="gp-loop-content">
								
										<h2 class="gp-loop-title"><a href="<?php if ( get_post_format() == 'link' ) { echo esc_url( get_post_meta( get_the_ID(), 'link', true ) ); } else { the_permalink(); } ?>" title="<?php the_title_attribute(); ?>"<?php if ( get_post_format() == 'link' ) { ?> target="<?php echo get_post_meta( get_the_ID(), 'link_target', true ); ?>"<?php } ?>><?php the_title(); ?></a></h2>
									
										<div class="gp-loop-meta">
											<time class="gp-post-meta gp-meta-date" itemprop="datePublished" datetime="<?php echo get_the_date( 'c' ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time>
										</div>	

									</div>
								
								<?php } ?>
														
							</section>
						
						</li>
					
					<?php endwhile; ?>	

				</ul>

				<script>
				jQuery( document ).ready( function( $ ) {
					
					'use strict';
					
					if ( $( 'body' ).hasClass( 'gp-theme' ) ) {
			
						var $window = $(window),
							flexslider = { vars:{} };

						function getGridSize() {
							return ( $window.width() <= 567 ) ? 1 : ( $window.width() <= 1023 ) ? <?php if ( $items_in_view == 1 ) { ?>1<?php } else { ?>2<?php } ?> : <?php echo absint( $items_in_view ); ?>;
						}

						$window.load(function() {
							$( '#<?php echo sanitize_html_class( $name ); ?>' ).flexslider({
								animation: 'slide',
								animationLoop: false,
								itemWidth: 537,
								itemMargin: 30,
								slideshowSpeed: <?php if ( $slider_speed != '0' ) { echo absint( $slider_speed ) * 1000; } else { echo '9999999'; } ?>,
								animationSpeed: <?php echo absint( $animation_speed * 1000 ); ?>,
								directionNav: <?php if ( $arrows == 'enabled' ) { ?>true<?php } else { ?>false<?php } ?>,			
								controlNav: <?php if ( $buttons == 'enabled' ) { ?>true<?php } else { ?>false<?php } ?>,			
								pauseOnAction: true, 
								pauseOnHover: false,
								prevText: '',
								nextText: '',
								minItems: getGridSize(),
								maxItems: getGridSize(),
								start: function(slider){
									flexslider = slider;
								}
							});	
						});
							
						$window.resize( function() {
							var gridSize = getGridSize();
							flexslider.vars.minItems = gridSize;
							flexslider.vars.maxItems = gridSize;
						});	
					
					}		

				});
				</script>

			</div>	

		<?php endif; wp_reset_postdata(); ?>
			 				
		<?php

		$output_string = ob_get_contents();
		ob_end_clean();
		return $output_string;

	}

}

add_shortcode( 'carousel', 'ghostpool_carousel' );
	
?>