<?php 

if ( ! function_exists( 'ghostpool_showcase' ) ) {

	function ghostpool_showcase( $atts, $content = null ) {	
		
		extract( shortcode_atts( array(
			'widget_title' => '',
			'images' => '',
			'cats' => '', 
			'hub_fields' => '',
			'page_ids' => '',
			'post_types' => 'post',
			'post_association' => 'disabled',	
			'ranking' => 'gp-no-ranking',
			'format' => 'gp-blog-horizontal',	
			'orderby' => 'newest',
			'release_date_from' => '',
			'release_date_to' => '',
			'filter_cats' => '',
			'filter_date' => '',
			'filter_title' => '',					
			'filter_comment_count' => '',
			'filter_views' => '',
			'filter_likes' => '',
			'filter_release_date' => '',
			'filter_release_date_asc' => '',
			'filter_site_rating' => '',
			'filter_user_rating' => '',
			'filter_cat_id' => '',
			'per_page' => '5',
			'offset' => '',
			'large_excerpt_length' => '80',
			'small_excerpt_length' => '0',
			'large_meta_release_date' => '',
			'large_meta_author' => '',
			'large_meta_date' => '',
			'large_meta_comment_count' => '',
			'large_meta_views' => '',
			'large_meta_likes' => '',
			'large_meta_followers' => '',
			'large_meta_cats' => '',
			'large_meta_tags' => '',
			'large_meta_hub_fields' => '',
			'large_meta_site_rating' => '',
			'large_meta_user_rating' => '',	
			'small_meta_release_date' => '',		
			'small_meta_author' => '',
			'small_meta_date' => '',
			'small_meta_comment_count' => '',
			'small_meta_views' => '',
			'small_meta_likes' => '',
			'small_meta_followers' => '',
			'small_meta_cats' => '',
			'small_meta_tags' => '',	
			'small_meta_hub_fields' => '',
			'small_meta_site_rating' => '',
			'small_meta_user_rating' => '',		
			'large_read_more_link' => 'disabled',
			'small_read_more_link' => 'disabled',
			'page_arrows' => 'disabled',
			'pagination' => 'disabled',
			'see_all' => 'disabled',
			'see_all_link' => '',
			'see_all_text' => esc_html__( 'See All Items', 'huber-plugin' ),
			'classes' => '',
			'icon_color' => '#fff',	
			'icon_bg_color' => '#fe4a49',
			'icon' => '',
			'title_color' => '',
			'post_title_color' => '',
			'post_title_hover_color' => '',
			'post_link_color' => '',
			'post_link_hover_color' => '',
			'post_text_color' => '',
			'meta_text_color' => '',
			'post_border_color' => '',
			'ranking_bg_color' => '',
			'ranking_text_color' => '',
		), $atts ) );
		
		// Load filter variables
		$type['cats'] = $filter_cats;
		$type['date'] = $filter_date;
		$type['title'] = $filter_title;
		$type['comment_count'] = $filter_comment_count;
		$type['views'] = $filter_views;
		$type['likes'] = $filter_likes;
		$type['release_date'] = $filter_release_date;
		$type['release_date_asc'] = $filter_release_date_asc;
		$type['site_rating'] = $filter_site_rating;
		$type['user_rating'] = $filter_user_rating;

		// Unique Name	
		STATIC $i = 0;
		$i++;
		$name = 'gp_showcase_wrapper_' . $i;
		
		// Get post or hub association ID
		$a_post_id = get_hub_association_id( get_the_ID() );
		
		// Add CSS styling to header
		ghostpool_shortcode_styling( $name, $title_color, $post_title_color, $post_title_hover_color, $post_link_color, $post_link_hover_color, $post_text_color, $meta_text_color, $post_border_color, $ranking_bg_color, $ranking_text_color );
		
		// Post counter
		$counter = 1;
		
		// Ranking counter;
		$ranking_counter = 1;
															
		$args = array(
			'post_status'         => 'publish',
			'post_type'      	  => $post_types ? explode( ',', $post_types ) : '',
			'post__in'            => $page_ids ? explode( ',', $page_ids ) : '',
			ghostpool_cats( $cats, 'param' ) => ghostpool_cats( $cats, 'variables' ),
			'tax_query'           => ghostpool_tax( $hub_fields ),
			'orderby' 		      => ghostpool_orderby( $orderby, 'orderby' ),
			'order' 		      => ghostpool_orderby( $orderby, 'order' ),	
			'meta_key' 		      => ghostpool_orderby( $orderby, 'meta_key' ),
			'meta_query' 		  => ghostpool_orderby( $orderby, 'meta_query', $release_date_from, $release_date_to, $post_association, get_hub_association_id( get_the_ID() ) ),
			'posts_per_page'      => $per_page,
			'offset' 		      => $offset,
			'paged'          	  => $pagination != 'disabled' ? ghostpool_paged() : 1,
			'ignore_sticky_posts' => 1,
		);
		
		$args = apply_filters( 'ghostpool_showcase_element_query', $args, $post_types, $page_ids, $cats, $hub_fields, $orderby, $release_date_from, $release_date_to, $post_association, $per_page, $offset );
		
		ob_start(); $gp_query = new WP_Query( $args ); ?>		
	
		<?php if ( $gp_query->have_posts() ) : ?>
			
			<div id="<?php echo sanitize_html_class( $name ); ?>" class="gp-showcase-wrapper gp-vc-element <?php echo sanitize_html_class( $format ); ?> <?php echo sanitize_html_class( $ranking ); ?> <?php echo esc_attr( $classes ); ?>" data-type="showcase" data-postid="<?php echo $a_post_id; ?>" data-cats="<?php echo esc_attr( $cats ); ?>" data-hubfields="<?php echo esc_attr( $hub_fields ); ?>" data-posttypes="<?php echo esc_attr( $post_types ); ?>" data-postassociation="<?php echo esc_attr( $post_association ); ?>" data-ranking="<?php echo esc_attr( $ranking ); ?>" data-format="<?php echo esc_attr( $format ); ?>" data-orderby="<?php echo esc_attr( $orderby ); ?>" data-releasedatefrom="<?php echo esc_attr( $release_date_from ); ?>" data-releasedateto="<?php echo esc_attr( $release_date_to ); ?>" data-perpage="<?php echo absint( $per_page ); ?>" data-offset="<?php echo esc_attr( $offset ); ?>" data-largeexcerptlength="<?php echo esc_attr( $large_excerpt_length ); ?>" data-smallexcerptlength="<?php echo esc_attr( $small_excerpt_length ); ?>" data-largemetareleasedate="<?php echo esc_attr( $large_meta_release_date ); ?>" data-smallmetareleasedate="<?php echo esc_attr( $small_meta_release_date ); ?>" data-largemetaauthor="<?php echo esc_attr( $large_meta_author ); ?>" data-smallmetaauthor="<?php echo esc_attr( $small_meta_author ); ?>" data-largemetadate="<?php echo esc_attr( $large_meta_date ); ?>" data-smallmetadate="<?php echo esc_attr( $small_meta_date ); ?>" data-largemetacommentcount="<?php echo esc_attr( $large_meta_comment_count ); ?>" data-smallmetacommentcount="<?php echo esc_attr( $small_meta_comment_count ); ?>" data-largemetaviews="<?php echo esc_attr( $large_meta_views ); ?>" data-smallmetaviews="<?php echo esc_attr( $small_meta_views ); ?>" data-largemetalikes="<?php echo esc_attr( $large_meta_likes ); ?>" data-largemetafollowers="<?php echo esc_attr( $large_meta_followers ); ?>" data-smallmetafollowers="<?php echo esc_attr( $small_meta_followers ); ?>" data-smallmetalikes="<?php echo esc_attr( $small_meta_likes ); ?>" data-largemetacats="<?php echo esc_attr( $large_meta_cats ); ?>" data-smallmetacats="<?php echo esc_attr( $small_meta_cats ); ?>" data-largemetatags="<?php echo esc_attr( $large_meta_tags ); ?>" data-smallmetatags="<?php echo esc_attr( $small_meta_tags ); ?>" data-largemetahubfields="<?php echo esc_attr( $large_meta_hub_fields ); ?>" data-smallmetahubfields="<?php echo esc_attr( $small_meta_hub_fields ); ?>" data-largemetasiterating="<?php echo esc_attr( $large_meta_site_rating ); ?>" data-smallmetasiterating="<?php echo esc_attr( $small_meta_site_rating ); ?>" data-largemetauserrating="<?php echo esc_attr( $large_meta_site_rating ); ?>" data-smallmetauserrating="<?php echo esc_attr( $small_meta_user_rating ); ?>" data-largereadmorelink="<?php echo esc_attr( $large_read_more_link ); ?>" data-smallreadmorelink="<?php echo esc_attr( $small_read_more_link ); ?>" data-pagearrows="<?php echo esc_attr( $page_arrows ); ?>" data-pagination="<?php echo esc_attr( $pagination ); ?>">

				<div class="gp-widget-title">
					
					<?php if ( $icon ) { ?><i class="gp-element-icon fa <?php echo sanitize_html_class( $icon ); ?>" style="<?php if ( $icon_color ) { ?>color: <?php echo esc_attr( $icon_color ); ?>;<?php } ?><?php if ( $icon_bg_color ) { ?>background-color: <?php echo esc_attr( $icon_bg_color ); ?>;<?php } ?>"></i><?php } ?>
					
					<?php if ( $widget_title ) { ?><h3 class="widgettitle"><?php echo esc_attr( $widget_title ); ?></h3><?php } ?>				
																											
					<?php ghostpool_filter(
						$type,
						$filter_cat_id,
						$orderby,
						$pagination,
						false
					); ?>
			
				</div>
				
				<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">				
						
					<?php if ( $page_arrows == 'enabled' ) { ?>
						<div class="gp-pagination gp-standard-pagination gp-pagination-arrows">
							<?php echo ghostpool_pagination_arrows( $gp_query->max_num_pages ); ?>
						</div>
					<?php } ?>
				
					<div class="gp-section-loop-inner">
		
						<?php while ( $gp_query->have_posts() ) : $gp_query->the_post(); 
					
							if ( $counter % $per_page == 1 ) {
								$excerpt_length = $large_excerpt_length;
								$meta_release_date = $large_meta_release_date;
								$meta_author = $large_meta_author;
								$meta_date = $large_meta_date;
								$meta_comment_count = $large_meta_comment_count;
								$meta_views = $large_meta_views;
								$meta_likes = $large_meta_likes;
								$meta_followers = $large_meta_followers;
								$meta_cats = $large_meta_cats;
								$meta_tags = $large_meta_tags;
								$meta_hub_fields = $large_meta_hub_fields;
								$meta_site_rating = $large_meta_site_rating;
								$meta_user_rating = $large_meta_user_rating;
								$read_more_link = $large_read_more_link;
							} else {
								$excerpt_length = $small_excerpt_length;
								$meta_release_date = $small_meta_release_date;
								$meta_author = $small_meta_author;
								$meta_date = $small_meta_date;
								$meta_comment_count = $small_meta_comment_count;
								$meta_views = $small_meta_views;
								$meta_likes = $small_meta_likes;
								$meta_followers = $small_meta_followers;
								$meta_cats = $small_meta_cats;
								$meta_tags = $small_meta_tags;
								$meta_hub_fields = $small_meta_hub_fields;
								$meta_site_rating = $small_meta_site_rating;
								$meta_user_rating = $small_meta_user_rating;
								$read_more_link = $small_read_more_link;	
							}
								
							if ( function_exists( 'ghostpool_post_loop_showcase' ) ) { ghostpool_post_loop_showcase( $format, $excerpt_length, $meta_release_date, $meta_author, $meta_date, $meta_comment_count, $meta_views, $meta_likes, $meta_followers, $meta_cats, $meta_tags, $meta_hub_fields, $meta_site_rating, $meta_user_rating, $read_more_link, $counter, $ranking, $ranking_counter, $per_page, $images, $gp_query->post_count ); }
								
						$counter++; $ranking_counter++; endwhile; ?>
					
					</div>

					<?php if ( $pagination == 'page-numbers' ) { ?>
						<?php echo ghostpool_pagination( $gp_query->max_num_pages, $pagination ); ?>
					<?php } ?>
							
				</div>
				
				<?php if ( $see_all == 'enabled' ) { ?>
					<a href="<?php echo esc_url( $see_all_link ); ?>" class="gp-see-all-link button"><?php echo esc_attr( $see_all_text ); ?></a>
				<?php } ?>
							
			</div>

		<?php endif; wp_reset_postdata(); ?>
								
		<?php

		$output_string = ob_get_contents();
		ob_end_clean();
		return $output_string;

	}

}

add_shortcode( 'showcase', 'ghostpool_showcase' );
	
?>