<?php

extract( shortcode_atts( array( 
	'image_url' => '',
	'image_width' => '230',
	'image_height' => '230',
	'name' => '',
	'position' => '',
	'link' => '',
	'link_target' => '',
 ), $atts ) );

ob_start(); 

global $columns, $ghostpool_counter;

$ghostpool_counter = $ghostpool_counter + 1;
if ( $ghostpool_counter % $columns == 1 ) {
	$left_column = 'gp-left-column';
} else {
	$left_column = '';
}

$column_width = 100 / $columns;	
	
?>

<div class="gp-team-member <?php echo sanitize_html_class( $left_column ); ?>" style="width: <?php echo floatval( $column_width ); ?>%;">
	
	<?php if ( $image_url ) { ?>

		<?php if ( $link != '' ) { ?><a href="<?php echo esc_url( $link ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php } ?>
			
			<img src="<?php echo esc_url( wp_get_attachment_url( $image_url ) ); ?>" width="<?php echo absint( $image_width ); ?>" height="<?php echo absint( $image_height ); ?>" alt="<?php if ( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ) { echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ); } else { the_title_attribute(); } ?>" class="gp-post-image gp-team-image" />								
		
		<?php if ( $link != '' ) { ?></a><?php } ?>
										
	<?php } ?>
						
	<div class="gp-team-name"><?php echo esc_attr( $name ); ?></div>
	
	<div class="gp-team-position"><?php echo esc_attr( $position ); ?></div>
	
	<div class="gp-team-description"><?php echo wpb_js_remove_wpautop( $content, true ); ?></div>

</div>

<?php

$output_string = ob_get_contents();
ob_end_clean(); 	
echo wp_kses_post( $output_string );

?>