<?php 

extract( shortcode_atts( array( 
	'effect'  => 'slide',
	'buttons' => 'false',
	'arrows'  => 'true',
	'speed'   => '0',
	'background_overlay' => 'enabled',
	'classes' => '',
	'css'		   => '',	
 ), $atts ) );

// CSS Editor
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $classes . vc_shortcode_custom_css_class( $css, ' ' ), '', $atts ); 
 
// Unique Name
STATIC $i = 0;
$i++;
$name = 'testimonial_slider_' . $i;

ob_start(); ?>

<div id="<?php echo sanitize_html_class( $name ); ?>" class="gp-testimonial-slider gp-slider <?php echo sanitize_html_class( $css_class ); ?>">
	<ul class="slides">
		<?php echo do_shortcode( $content ); ?>
	</ul>
</div>

<?php

$output_string = ob_get_contents();
ob_end_clean(); 
echo wp_kses_post( $output_string );

?> 

<script>
jQuery( document ).ready( function( $ ) {
	'use strict';
	if ( $( 'body' ).hasClass( 'gp-theme' ) ) {
		$( window ).on( 'load', function() {
			$( '#<?php echo sanitize_html_class( $name ); ?>.gp-slider' ).flexslider( { 
				animation: '<?php echo esc_attr( $effect ); ?>',
				slideshowSpeed: <?php if ( $speed == 0 ) { echo '9999999'; } else { echo absint( $speed ) * 1000; } ?>,
				animationSpeed: 600,
				smoothHeight: false,   
				directionNav: <?php if ( $arrows == 'true' ) { ?>true<?php } else { ?>false<?php } ?>,			
				controlNav: <?php if ( $buttons == 'true' ) { ?>true<?php } else { ?>false<?php } ?>,				
				pauseOnAction: true, 
				pauseOnHover: false,
				prevText: '',
				nextText: '',
				touch: true
			});
		});
	}
});
</script>