<?php if ( ! class_exists( 'GhostPool_Shortcodes' ) ) {

	class GhostPool_Shortcodes {

		public function __construct() {
			add_action( 'init', array( &$this, 'ghostpool_shortcodes' ) );
			add_action( 'vc_before_init', array( &$this, 'ghostpool_vc_functions' ), 9 );
		}

		public function ghostpool_vc_functions() {
			if ( function_exists( 'vc_set_as_theme' ) ) {
				vc_set_as_theme(); // Disable design options
				vc_set_shortcodes_templates_dir( dirname( __FILE__ ) ); // Set templates directory
				vc_set_default_editor_post_types( array( 'page', 'epx_vcsb', 'vc-element' ) ); // Check VC post type checkboxes by default
			}
		}


		public function ghostpool_shortcodes() {
	
			if ( function_exists( 'vc_set_as_theme' ) ) {

				/*--------------------------------------------------------------
				If plugin is activated without theme
				--------------------------------------------------------------*/
		
				// Functions
				if ( ! function_exists( 'ghostpool_option' ) ) {
					function ghostpool_option() {}
				}	
				if ( ! function_exists( 'ghostpool_excerpt' ) ) {
					function ghostpool_excerpt() {}
				}	
				if ( ! function_exists( 'ghostpool_pagination_arrows' ) ) {
					function ghostpool_pagination_arrows() {}
				}
				if ( ! function_exists( 'ghostpool_exclude_cats' ) ) {
					function ghostpool_exclude_cats() {}
				}
				if ( ! function_exists( 'ghostpool_pagination' ) ) {
					function ghostpool_pagination() {}
				}
				if ( ! function_exists( 'ghostpool_cats' ) ) {
					function ghostpool_cats() {}
				}
				if ( ! function_exists( 'ghostpool_tax' ) ) {
					function ghostpool_tax() {}
				}				
				if ( ! function_exists( 'ghostpool_orderby' ) ) {
					function ghostpool_orderby() {}
				}
				if ( ! function_exists( 'ghostpool_paged' ) ) {
					function ghostpool_paged() {}
				}
				if ( ! function_exists( 'ghostpool_filter' ) ) {
					function ghostpool_filter() {}
				}
				if ( ! function_exists( 'get_hub_association_id' ) ) {
					function get_hub_association_id() {}
				}
				
							
				/*--------------------------------------------------------------
				Custom icon selection field
				--------------------------------------------------------------*/
		
				function ghostpool_icon_selection_vc_option( $settings, $value ) {
					$output = '<div class="gp-icon-container">';
					foreach ( $settings['value'] as $val ) {		   
						$output .= '<a href="' . esc_attr( $val ) . '" class="gp-icon-link"><i class="fa fa-lg ' . esc_attr( $val ) . '"></i></a>';		
					}
					$output .= '</div><a href="#" class="gp-all-icons-button">' . esc_html__( 'Show All Icons', 'huber-plugin' ) . '</a><input name="' . esc_attr( $settings['param_name'] ) . '" id="gp-icon-selection-value" class="wpb_vc_param_value ' . esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . esc_attr( $value ) . '" />';    
					return $output;
				}
				vc_add_shortcode_param( 'icon_selection', 'ghostpool_icon_selection_vc_option', plugins_url( 'assets/icon-selection.js', dirname( __FILE__ ) ) );	


				/*--------------------------------------------------------------
				Custom date picker field
				--------------------------------------------------------------*/
		
				function ghostpool_date_picker_vc_option( $settings, $value ) {
					$output = '<input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value gp-datepicker ' . esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="text" value="' . esc_attr( $value ) . '" />		
					<script>
					jQuery( document ).ready( function( $ ) {
						$( function() {
							$( ".gp-datepicker" ).datepicker({ constrainInput: false });
						});
					});
					</script>';
					return $output;
				}
				vc_add_shortcode_param( 'date_picker', 'ghostpool_date_picker_vc_option' );	


				/*--------------------------------------------------------------
				Custom image size selector
				--------------------------------------------------------------*/
		
				function ghostpool_image_sizes_vc_options() {
					global $_wp_additional_image_sizes;
					$output = array();
					$sizes = array();
					foreach ( get_intermediate_image_sizes() as $_size ) {
						if ( in_array( $_size, array( 'thumbnail', 'medium', 'medium_large', 'large' ) ) ) {
							$sizes[ $_size ]['width']  = get_option( "{$_size}_size_w" );
							$sizes[ $_size ]['height'] = get_option( "{$_size}_size_h" );
							//$sizes[ $_size ]['crop']   = (bool) get_option( "{$_size}_crop" );
						} elseif ( isset( $_wp_additional_image_sizes[ $_size ] ) ) {
							$sizes[ $_size ] = array(
								'width'  => $_wp_additional_image_sizes[ $_size ]['width'],
								'height' => $_wp_additional_image_sizes[ $_size ]['height'],
								//'crop'   => $_wp_additional_image_sizes[ $_size ]['crop'],
							);
						}
						$name = $_size . ' (' . $sizes[ $_size ]['width'] . ' x ' . $sizes[ $_size ]['height'] . ')';
						$output[ $name ] = $_size;		
					}
					return array_merge( array( esc_html__( 'Default', 'huber-plugin' ) => 'default' ), $output );
				}
									
				/**
				 * Added shortcode styling to header
				 *
				 */	
				if ( ! function_exists( 'ghostpool_shortcode_styling' ) ) {
					function ghostpool_shortcode_styling( $name = '', $title_color = '', $post_title_color = '', $post_title_hover_color = '', $post_link_color = '', $post_link_hover_color = '', $post_text_color = '', $meta_text_color = '', $post_border_color = '', $ranking_bg_color = '', $ranking_text_color = '' ) {
					
						wp_enqueue_style( 'ghostpool-shortcodes-style', plugins_url( 'assets/shortcodes-style.css', dirname( __FILE__ ) ) );
						
						$custom_css = '';

						if ( $title_color ) { 
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-widget-title h3{color:' . esc_attr( $title_color ) . ';}';
						}
						if ( $post_title_color ) {
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-loop-title a, #' . sanitize_html_class( $name ) . ' ul.page-numbers .page-numbers, #' . sanitize_html_class( $name ) . ' ul.page-numbers a.page-numbers:hover{color:' . esc_attr( $post_title_color ) . ';}';
						} 
						if ( $post_title_hover_color ) {
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-loop-title a:hover, #' . sanitize_html_class( $name ) . ' ul.page-numbers a.page-numbers{color:' . esc_attr( $post_title_hover_color ) . ';}';
						}
						if ( $post_link_color ) { 
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-loop-content a{color:' . esc_attr( $post_link_color ) . ';}';
						}
						if ( $post_link_hover_color ) { 
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-loop-text a:hover{color:' . esc_attr( $post_link_hover_color ) . ';}';
						}		
						if ( $post_text_color ) { 
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-loop-text{color:' . esc_attr( $post_text_color ) . ';}';
						}
						if ( $meta_text_color ) {
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-loop-meta, #' . sanitize_html_class( $name ) . ' .gp-loop-meta a{color:' . esc_attr( $meta_text_color ) . ';}';
						}	
						if ( $post_border_color ) {
							$custom_css .= '#' . sanitize_html_class( $name ) . '.gp-blog-list .gp-section-loop-inner section, #' . sanitize_html_class( $name ) . '.gp-blog-vertical section{border-color:' . esc_attr( $post_border_color ) . ';}';
						}	
						if ( $ranking_bg_color ) {
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-ranking-counter{background-color:' . esc_attr( $ranking_bg_color ) . ';}';
						}						
						if ( $ranking_text_color ) {
							$custom_css .= '#' . sanitize_html_class( $name ) . ' .gp-ranking-counter{color:' . esc_attr( $ranking_text_color ) . ';}';
						}
							
						wp_add_inline_style( 'ghostpool-shortcodes-style', $custom_css );
							
					}
				}		
				add_action( 'wp_head', 'ghostpool_shortcode_styling' );
			
				/*--------------------------------------------------------------
				Remove deprecated shortcodes in Gauge and The Review themes
				--------------------------------------------------------------*/
		
				add_shortcode( 'news', '__return_false' );		
				add_shortcode( 'videos', '__return_false' );		
				add_shortcode( 'portfolio', '__return_false' );			
				add_shortcode( 'ranking', '__return_false' );	
				add_shortcode( 'images', '__return_false' );
				add_shortcode( 'filters', '__return_false' );
				add_shortcode( 'featured', '__return_false' );
				add_shortcode( 'advertisement', '__return_false' );
				add_shortcode( 'user_rating_box', '__return_false' );
				add_shortcode( 'slider', '__return_false' );
				add_shortcode( 'hub_details', '__return_false' );
				add_shortcode( 'social', '__return_false' );

			
				/*--------------------------------------------------------------
				Custom Shortcodes
				--------------------------------------------------------------*/
		
				// Only load admin CSS if using theme
				if ( file_exists( get_template_directory_uri() . '/lib/framework/css/general-admin.css' ) && file_exists( get_template_directory_uri() . '/lib/fonts/font-awesome/css/font-awesome.min.css' ) ) {
					$admin_css = array( get_template_directory_uri() . '/lib/framework/css/general-admin.css', get_template_directory_uri() . '/lib/fonts/font-awesome/css/font-awesome.min.css', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css' );
				} else {
					$admin_css = '';
				}
				
				// Only load JS files if using theme
				if ( file_exists( get_template_directory_uri() . '/lib/scripts/jquery.flexslider-min.js' ) ) {
					$flexslider_js = get_template_directory_uri() . '/lib/scripts/jquery.flexslider-min.js';
				} else {
					$flexslider_js = '';
				}
				if ( file_exists( get_template_directory_uri() . '/lib/scripts/isotope.pkgd.min.js' ) ) {
					$masonry_js = array( get_template_directory_uri() . '/lib/scripts/isotope.pkgd.min.js' );
				} else {
					$masonry_js = '';
				}

				// Icons
				$icons = array( '', 'fa-500px', 'fa-adjust', 'fa-adn', 'fa-align-center', 'fa-align-justify', 'fa-align-left', 'fa-align-right', 'fa-amazon', 'fa-ambulance', 'fa-american-sign-language-interpreting', 'fa-anchor', 'fa-android', 'fa-angellist', 'fa-angle-double-down', 'fa-angle-double-left', 'fa-angle-double-right', 'fa-angle-double-up', 'fa-angle-down', 'fa-angle-left', 'fa-angle-right', 'fa-angle-up', 'fa-apple', 'fa-archive', 'fa-area-chart', 'fa-arrow-circle-down', 'fa-arrow-circle-left', 'fa-arrow-circle-o-down', 'fa-arrow-circle-o-left', 'fa-arrow-circle-o-right', 'fa-arrow-circle-o-up', 'fa-arrow-circle-right', 'fa-arrow-circle-up', 'fa-arrow-down', 'fa-arrow-left', 'fa-arrow-right', 'fa-arrow-up', 'fa-arrows', 'fa-arrows-alt', 'fa-arrows-h', 'fa-arrows-v', 'fa-asl-interpreting', 'fa-assistive-listening-systems', 'fa-asterisk', 'fa-at', 'fa-audio-description', 'fa-automobile', 'fa-backward', 'fa-balance-scale', 'fa-ban', 'fa-bank', 'fa-bar-chart', 'fa-bar-chart-o', 'fa-barcode', 'fa-bars', 'fa-battery-0', 'fa-battery-1', 'fa-battery-2', 'fa-battery-3', 'fa-battery-4', 'fa-battery-empty', 'fa-battery-full', 'fa-battery-half', 'fa-battery-quarter', 'fa-battery-three-quarters', 'fa-bed', 'fa-beer', 'fa-behance', 'fa-behance-square', 'fa-bell', 'fa-bell-o', 'fa-bell-slash', 'fa-bell-slash-o', 'fa-bicycle', 'fa-binoculars', 'fa-birthday-cake', 'fa-bitbucket', 'fa-bitbucket-square', 'fa-bitcoin', 'fa-black-tie', 'fa-blind', 'fa-bluetooth', 'fa-bluetooth-b', 'fa-bold', 'fa-bolt', 'fa-bomb', 'fa-book', 'fa-bookmark', 'fa-bookmark-o', 'fa-braille', 'fa-briefcase', 'fa-btc', 'fa-bug', 'fa-building', 'fa-building-o', 'fa-bullhorn', 'fa-bullseye', 'fa-bus', 'fa-buysellads', 'fa-cab', 'fa-calculator', 'fa-calendar', 'fa-calendar-check-o', 'fa-calendar-minus-o', 'fa-calendar-o', 'fa-calendar-plus-o', 'fa-calendar-times-o', 'fa-camera', 'fa-camera-retro', 'fa-car', 'fa-caret-down', 'fa-caret-left', 'fa-caret-right', 'fa-caret-square-o-down', 'fa-caret-square-o-left', 'fa-caret-square-o-right', 'fa-caret-square-o-up', 'fa-caret-up', 'fa-cart-arrow-down', 'fa-cart-plus', 'fa-cc', 'fa-cc-amex', 'fa-cc-diners-club', 'fa-cc-discover', 'fa-cc-jcb', 'fa-cc-mastercard', 'fa-cc-paypal', 'fa-cc-stripe', 'fa-cc-visa', 'fa-certificate', 'fa-chain', 'fa-chain-broken', 'fa-check', 'fa-check-circle', 'fa-check-circle-o', 'fa-check-square', 'fa-check-square-o', 'fa-chevron-circle-down', 'fa-chevron-circle-left', 'fa-chevron-circle-right', 'fa-chevron-circle-up', 'fa-chevron-down', 'fa-chevron-left', 'fa-chevron-right', 'fa-chevron-up', 'fa-child', 'fa-chrome', 'fa-circle', 'fa-circle-o', 'fa-circle-o-notch', 'fa-circle-thin', 'fa-clipboard', 'fa-clock-o', 'fa-clone', 'fa-close', 'fa-cloud', 'fa-cloud-download', 'fa-cloud-upload', 'fa-cny', 'fa-code', 'fa-code-fork', 'fa-codepen', 'fa-codiepie', 'fa-coffee', 'fa-cog', 'fa-cogs', 'fa-columns', 'fa-comment', 'fa-comment-o', 'fa-commenting', 'fa-commenting-o', 'fa-comments', 'fa-comments-o', 'fa-compass', 'fa-compress', 'fa-connectdevelop', 'fa-contao', 'fa-copy', 'fa-copyright', 'fa-creative-commons', 'fa-credit-card', 'fa-credit-card-alt', 'fa-crop', 'fa-crosshairs', 'fa-css3', 'fa-cube', 'fa-cubes', 'fa-cut', 'fa-cutlery', 'fa-dashboard', 'fa-dashcube', 'fa-database', 'fa-deaf', 'fa-deafness', 'fa-dedent', 'fa-delicious', 'fa-desktop', 'fa-deviantart', 'fa-diamond', 'fa-digg', 'fa-dollar', 'fa-dot-circle-o', 'fa-download', 'fa-dribbble', 'fa-dropbox', 'fa-drupal', 'fa-edge', 'fa-edit', 'fa-eject', 'fa-ellipsis-h', 'fa-ellipsis-v', 'fa-empire', 'fa-envelope', 'fa-envelope-o', 'fa-envelope-square', 'fa-envira', 'fa-eraser', 'fa-eur', 'fa-euro', 'fa-exchange', 'fa-exclamation', 'fa-exclamation-circle', 'fa-exclamation-triangle', 'fa-expand', 'fa-expeditedssl', 'fa-external-link', 'fa-external-link-square', 'fa-eye', 'fa-eye-slash', 'fa-eyedropper', 'fa-fa', 'fa-facebook', 'fa-facebook-f', 'fa-facebook-official', 'fa-facebook-square', 'fa-fast-backward', 'fa-fast-forward', 'fa-fax', 'fa-feed', 'fa-female', 'fa-fighter-jet', 'fa-file', 'fa-file-archive-o', 'fa-file-audio-o', 'fa-file-code-o', 'fa-file-excel-o', 'fa-file-image-o', 'fa-file-movie-o', 'fa-file-o', 'fa-file-pdf-o', 'fa-file-photo-o', 'fa-file-picture-o', 'fa-file-powerpoint-o', 'fa-file-sound-o', 'fa-file-text', 'fa-file-text-o', 'fa-file-video-o', 'fa-file-word-o', 'fa-file-zip-o', 'fa-files-o', 'fa-film', 'fa-filter', 'fa-fire', 'fa-fire-extinguisher', 'fa-firefox', 'fa-first-order', 'fa-flag', 'fa-flag-checkered', 'fa-flag-o', 'fa-flash', 'fa-flask', 'fa-flickr', 'fa-floppy-o', 'fa-folder', 'fa-folder-o', 'fa-folder-open', 'fa-folder-open-o', 'fa-font', 'fa-font-awesome', 'fa-fonticons', 'fa-fort-awesome', 'fa-forumbee', 'fa-forward', 'fa-foursquare', 'fa-frown-o', 'fa-futbol-o', 'fa-gamepad', 'fa-gavel', 'fa-gbp', 'fa-ge', 'fa-gear', 'fa-gears', 'fa-genderless', 'fa-get-pocket', 'fa-gg', 'fa-gg-circle', 'fa-gift', 'fa-git', 'fa-git-square', 'fa-github', 'fa-github-alt', 'fa-github-square', 'fa-gitlab', 'fa-gittip', 'fa-glass', 'fa-glide', 'fa-glide-g', 'fa-globe', 'fa-google', 'fa-google-plus', 'fa-google-plus-circle', 'fa-google-plus-official', 'fa-google-plus-square', 'fa-google-wallet', 'fa-graduation-cap', 'fa-gratipay', 'fa-group', 'fa-h-square', 'fa-hacker-news', 'fa-hand-grab-o', 'fa-hand-lizard-o', 'fa-hand-o-down', 'fa-hand-o-left', 'fa-hand-o-right', 'fa-hand-o-up', 'fa-hand-paper-o', 'fa-hand-peace-o', 'fa-hand-pointer-o', 'fa-hand-rock-o', 'fa-hand-scissors-o', 'fa-hand-spock-o', 'fa-hand-stop-o', 'fa-hard-of-hearing', 'fa-hashtag', 'fa-hdd-o', 'fa-header', 'fa-headphones', 'fa-heart', 'fa-heart-o', 'fa-heartbeat', 'fa-history', 'fa-home', 'fa-hospital-o', 'fa-hotel', 'fa-hourglass', 'fa-hourglass-1', 'fa-hourglass-2', 'fa-hourglass-3', 'fa-hourglass-end', 'fa-hourglass-half', 'fa-hourglass-o', 'fa-hourglass-start', 'fa-houzz', 'fa-html5', 'fa-i-cursor', 'fa-ils', 'fa-image', 'fa-inbox', 'fa-indent', 'fa-industry', 'fa-info', 'fa-info-circle', 'fa-inr', 'fa-instagram', 'fa-institution', 'fa-internet-explorer', 'fa-intersex', 'fa-ioxhost', 'fa-italic', 'fa-joomla', 'fa-jpy', 'fa-jsfiddle', 'fa-key', 'fa-keyboard-o', 'fa-krw', 'fa-language', 'fa-laptop', 'fa-lastfm', 'fa-lastfm-square', 'fa-leaf', 'fa-leanpub', 'fa-legal', 'fa-lemon-o', 'fa-level-down', 'fa-level-up', 'fa-life-bouy', 'fa-life-buoy', 'fa-life-ring', 'fa-life-saver', 'fa-lightbulb-o', 'fa-line-chart', 'fa-link', 'fa-linkedin', 'fa-linkedin-square', 'fa-linux', 'fa-list', 'fa-list-alt', 'fa-list-ol', 'fa-list-ul', 'fa-location-arrow', 'fa-lock', 'fa-long-arrow-down', 'fa-long-arrow-left', 'fa-long-arrow-right', 'fa-long-arrow-up', 'fa-low-vision', 'fa-magic', 'fa-magnet', 'fa-mail-forward', 'fa-mail-reply', 'fa-mail-reply-all', 'fa-male', 'fa-map', 'fa-map-marker', 'fa-map-o', 'fa-map-pin', 'fa-map-signs', 'fa-mars', 'fa-mars-double', 'fa-mars-stroke', 'fa-mars-stroke-h', 'fa-mars-stroke-v', 'fa-maxcdn', 'fa-meanpath', 'fa-medium', 'fa-medkit', 'fa-meh-o', 'fa-mercury', 'fa-microphone', 'fa-microphone-slash', 'fa-minus', 'fa-minus-circle', 'fa-minus-square', 'fa-minus-square-o', 'fa-mixcloud', 'fa-mobile', 'fa-mobile-phone', 'fa-modx', 'fa-money', 'fa-moon-o', 'fa-mortar-board', 'fa-motorcycle', 'fa-mouse-pointer', 'fa-music', 'fa-navicon', 'fa-neuter', 'fa-newspaper-o', 'fa-object-group', 'fa-object-ungroup', 'fa-odnoklassniki', 'fa-odnoklassniki-square', 'fa-opencart', 'fa-openid', 'fa-opera', 'fa-optin-monster', 'fa-outdent', 'fa-pagelines', 'fa-paint-brush', 'fa-paper-plane', 'fa-paper-plane-o', 'fa-paperclip', 'fa-paragraph', 'fa-paste', 'fa-pause', 'fa-pause-circle', 'fa-pause-circle-o', 'fa-paw', 'fa-paypal', 'fa-pencil', 'fa-pencil-square', 'fa-pencil-square-o', 'fa-percent', 'fa-phone', 'fa-phone-square', 'fa-photo', 'fa-picture-o', 'fa-pie-chart', 'fa-pied-piper', 'fa-pied-piper-alt', 'fa-pied-piper-pp', 'fa-pinterest', 'fa-pinterest-p', 'fa-pinterest-square', 'fa-plane', 'fa-play', 'fa-play-circle', 'fa-play-circle-o', 'fa-plug', 'fa-plus', 'fa-plus-circle', 'fa-plus-square', 'fa-plus-square-o', 'fa-power-off', 'fa-print', 'fa-product-hunt', 'fa-puzzle-piece', 'fa-qq', 'fa-qrcode', 'fa-question', 'fa-question-circle', 'fa-question-circle-o', 'fa-quote-left', 'fa-quote-right', 'fa-ra', 'fa-random', 'fa-rebel', 'fa-recycle', 'fa-reddit', 'fa-reddit-alien', 'fa-reddit-square', 'fa-refresh', 'fa-registered', 'fa-remove', 'fa-renren', 'fa-reorder', 'fa-repeat', 'fa-reply', 'fa-reply-all', 'fa-resistance', 'fa-retweet', 'fa-rmb', 'fa-road', 'fa-rocket', 'fa-rotate-left', 'fa-rotate-right', 'fa-rouble', 'fa-rss', 'fa-rss-square', 'fa-rub', 'fa-ruble', 'fa-rupee', 'fa-safari', 'fa-save', 'fa-scissors', 'fa-scribd', 'fa-search', 'fa-search-minus', 'fa-search-plus', 'fa-sellsy', 'fa-send', 'fa-send-o', 'fa-server', 'fa-share', 'fa-share-alt', 'fa-share-alt-square', 'fa-share-square', 'fa-share-square-o', 'fa-shekel', 'fa-sheqel', 'fa-shield', 'fa-ship', 'fa-shirtsinbulk', 'fa-shopping-bag', 'fa-shopping-basket', 'fa-shopping-cart', 'fa-sign-in', 'fa-sign-language', 'fa-sign-out', 'fa-signal', 'fa-signing', 'fa-simplybuilt', 'fa-sitemap', 'fa-skyatlas', 'fa-skype', 'fa-slack', 'fa-sliders', 'fa-slideshare', 'fa-smile-o', 'fa-snapchat', 'fa-snapchat-ghost', 'fa-snapchat-square', 'fa-soccer-ball-o', 'fa-sort', 'fa-sort-alpha-asc', 'fa-sort-alpha-desc', 'fa-sort-amount-asc', 'fa-sort-amount-desc', 'fa-sort-asc', 'fa-sort-desc', 'fa-sort-down', 'fa-sort-numeric-asc', 'fa-sort-numeric-desc', 'fa-sort-up', 'fa-soundcloud', 'fa-space-shuttle', 'fa-spinner', 'fa-spoon', 'fa-spotify', 'fa-square', 'fa-square-o', 'fa-stack-exchange', 'fa-stack-overflow', 'fa-star', 'fa-star-half', 'fa-star-half-empty', 'fa-star-half-full', 'fa-star-half-o', 'fa-star-o', 'fa-steam', 'fa-steam-square', 'fa-step-backward', 'fa-step-forward', 'fa-stethoscope', 'fa-sticky-note', 'fa-sticky-note-o', 'fa-stop', 'fa-stop-circle', 'fa-stop-circle-o', 'fa-street-view', 'fa-strikethrough', 'fa-stumbleupon', 'fa-stumbleupon-circle', 'fa-subscript', 'fa-subway', 'fa-suitcase', 'fa-sun-o', 'fa-superscript', 'fa-support', 'fa-table', 'fa-tablet', 'fa-tachometer', 'fa-tag', 'fa-tags', 'fa-tasks', 'fa-taxi', 'fa-television', 'fa-tencent-weibo', 'fa-terminal', 'fa-text-height', 'fa-text-width', 'fa-th', 'fa-th-large', 'fa-th-list', 'fa-themeisle', 'fa-thumb-tack', 'fa-thumbs-down', 'fa-thumbs-o-down', 'fa-thumbs-o-up', 'fa-thumbs-up', 'fa-ticket', 'fa-times', 'fa-times-circle', 'fa-times-circle-o', 'fa-tint', 'fa-toggle-down', 'fa-toggle-left', 'fa-toggle-off', 'fa-toggle-on', 'fa-toggle-right', 'fa-toggle-up', 'fa-trademark', 'fa-train', 'fa-transgender', 'fa-transgender-alt', 'fa-trash', 'fa-trash-o', 'fa-tree', 'fa-trello', 'fa-tripadvisor', 'fa-trophy', 'fa-truck', 'fa-try', 'fa-tty', 'fa-tumblr', 'fa-tumblr-square', 'fa-turkish-lira', 'fa-tv', 'fa-twitch', 'fa-twitter', 'fa-twitter-square', 'fa-umbrella', 'fa-underline', 'fa-undo', 'fa-universal-access', 'fa-university', 'fa-unlink', 'fa-unlock', 'fa-unlock-alt', 'fa-unsorted', 'fa-upload', 'fa-usb', 'fa-usd', 'fa-user', 'fa-user-md', 'fa-user-plus', 'fa-user-secret', 'fa-user-times', 'fa-users', 'fa-venus', 'fa-venus-double', 'fa-venus-mars', 'fa-viacoin', 'fa-viadeo', 'fa-viadeo-square', 'fa-video-camera', 'fa-vimeo', 'fa-vimeo-square', 'fa-vine', 'fa-vk', 'fa-volume-control-phone', 'fa-volume-down', 'fa-volume-off', 'fa-volume-up', 'fa-warning', 'fa-wechat', 'fa-weibo', 'fa-weixin', 'fa-whatsapp', 'fa-wheelchair', 'fa-wheelchair-alt', 'fa-wifi', 'fa-wikipedia-w', 'fa-windows', 'fa-won', 'fa-wordpress', 'fa-wpbeginner', 'fa-wpforms', 'fa-wrench', 'fa-xing', 'fa-xing-square', 'fa-y-combinator', 'fa-y-combinator-square', 'fa-yahoo', 'fa-yc', 'fa-yc-square', 'fa-yelp', 'fa-yen', 'fa-yoast', 'fa-youtube', 'fa-youtube-play', 'fa-youtube-square' );

											
				/*--------------------------------------------------------------
				Blog Shortcode
				--------------------------------------------------------------*/
		
				require_once( sprintf( "%s/gp_vc_blog.php", dirname( __FILE__ ) ) );

				vc_map( array( 
					'name' => esc_html__( 'Blog', 'huber-plugin' ),
					'base' => 'blog',
					'description' => esc_html__( 'Display content in a variety of ways.', 'huber-plugin' ),
					'class' => 'wpb_vc_blog',
					'controls' => 'full',
					'icon' => 'gp-icon-blog',
					'category' => esc_html__( 'Content', 'huber-plugin' ),			
					'admin_enqueue_css' => $admin_css,
					'front_enqueue_css' => $admin_css,
					'front_enqueue_js' => $masonry_js,
					'params' => array(		
						array( 
						'heading' => esc_html__( 'Title', 'huber-plugin' ),
						'description' => esc_html__( 'The title at the top of the element.', 'huber-plugin' ),
						'param_name' => 'widget_title',
						'type' => 'textfield',
						'admin_label' => true,
						'value' => '',
						),								
						array( 
						'heading' => esc_html__( 'Categories', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the slugs or IDs separating each one with a comma e.g. xbox,ps3,pc.', 'huber-plugin' ),
						'param_name' => 'cats',
						'type' => 'textfield',
						),				
						array( 
						'heading' => esc_html__( 'Hub Fields', 'huber-plugin' ),
						'description' => wp_kses( __( 'Enter the hub fields you want to filter by. Add the taxonomy slug followed by a colon. Next enter the terms separating each by a colon also. Next add a comma and then enter the next taxonomy and so on e.g. <code>taxonomy-1:term-1:term-2,taxonomy-2:term-1,taxonomy-3:term-1:term-2</code>, this would translate to <code>genre:action:role-playing,publisher:namco,developed-by:namco:bluepoint-games</code>', 'huber-plugin' ), array( 'code' => array() ) ),
						'param_name' => 'hub_fields',
						'type' => 'textfield',
						'value' => '',
						),				
						array( 
						'heading' => esc_html__( 'Page IDs', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the IDs of the pages you want to include, separating each with a comma e.g. 48,142.', 'huber-plugin' ),
						'param_name' => 'page_ids',
						'type' => 'textfield',
						),			
						array( 
						'heading' => esc_html__( 'Post Types', 'huber-plugin' ),
						'description' => esc_html__( 'Separate each post type with a comma e.g. post, page.', 'huber-plugin' ),
						'param_name' => 'post_types',
						'type' => 'posttypes',
						'value' => 'post',
						),				
						array( 
						'heading' => esc_html__( 'Post Association', 'huber-plugin' ),
						'description' => esc_html__( 'Choose whether to only show items associated with the hub this is added to.', 'huber-plugin' ),
						'param_name' => 'post_association',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),	
						array( 
						'heading' => esc_html__( 'Ranking', 'huber-plugin' ),
						'description' => esc_html__( 'Add ranking numbers to your items', 'huber-plugin' ),
						'param_name' => 'ranking',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'gp-no-ranking', esc_html__( 'Enabled', 'huber-plugin' ) => 'gp-ranking' ),
						'type' => 'dropdown',
						),	
						array( 
						'heading' => esc_html__( 'Format', 'huber-plugin' ),
						'description' => esc_html__( 'The format to display the items in.', 'huber-plugin' ),
						'param_name' => 'format',
						'value' => array( 
							esc_html__( 'List', 'huber-plugin' ) => 'gp-blog-list', 
							esc_html__( 'Minimal', 'huber-plugin' ) => 'gp-blog-minimal',
							esc_html__( '1 Column', 'huber-plugin' ) => 'gp-blog-columns-1', 
							esc_html__( '2 Columns', 'huber-plugin' ) => 'gp-blog-columns-2', 
							esc_html__( '3 Columns', 'huber-plugin' ) => 'gp-blog-columns-3', 
							esc_html__( '4 Columns', 'huber-plugin' ) => 'gp-blog-columns-4', 
							esc_html__( '5 Columns', 'huber-plugin' ) => 'gp-blog-columns-5', 
							esc_html__( '6 Columns', 'huber-plugin' ) => 'gp-blog-columns-6', 
							esc_html__( 'Masonry', 'huber-plugin' ) => 'gp-blog-masonry' 
						),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Order By', 'huber-plugin' ),
						'description' => esc_html__( 'The criteria which the items are ordered by.', 'huber-plugin' ),
						'param_name' => 'orderby',
						'value' => array(
							esc_html__( 'Newest', 'huber-plugin' ) => 'newest',
							esc_html__( 'Oldest', 'huber-plugin' ) => 'oldest',
							esc_html__( 'Title (A-Z)', 'huber-plugin' ) => 'title_az',
							esc_html__( 'Title (Z-A)', 'huber-plugin' ) => 'title_za',
							esc_html__( 'Most Comments', 'huber-plugin' ) => 'comment_count',
							esc_html__( 'Most Views', 'huber-plugin' ) => 'views',
							esc_html__( 'Most Likes', 'huber-plugin' ) => 'likes',
							esc_html__( 'Menu Order', 'huber-plugin' ) => 'menu_order',
							esc_html__( 'Random', 'huber-plugin' ) => 'rand',
							esc_html__( 'Latest Releases', 'huber-plugin' ) => 'release_date',
							esc_html__( 'Oldest Releases', 'huber-plugin' ) => 'release_date_asc',
							esc_html__( 'Top Site Rated', 'huber-plugin' ) => 'site_rating',
							esc_html__( 'Top User Rated', 'huber-plugin' ) => 'user_rating',
						),
						'type' => 'dropdown',
						),	
						array( 
						'heading' => esc_html__( 'Release Date From', 'huber-plugin' ),
						'description' => esc_html__( 'Enter "today" to use today\'s date e.g. only displays items with a release date later than today\'s date.', 'huber-plugin' ),
						'param_name' => 'release_date_from',
						'type' => 'date_picker',
						),
						array( 
						'heading' => esc_html__( 'Release Date To', 'huber-plugin' ),
						'description' => esc_html__( 'Enter "today" to use today\'s date e.g. only displays items with a release date with today\'s date and earlier.', 'huber-plugin' ),
						'param_name' => 'release_date_to',
						'type' => 'date_picker',
						),	 
						array( 
						'heading' => esc_html__( 'Items Per Page', 'huber-plugin' ),
						'description' => esc_html__( 'The number of items on each page.', 'huber-plugin' ),
						'param_name' => 'per_page',
						'value' => '9',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Offset', 'huber-plugin' ),
						'description' => esc_html__( 'The number of items to offset by e.g. set to 3 to exclude the first 3 posts.', 'huber-plugin' ),
						'param_name' => 'offset',
						'value' => '',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Standard Post Image Size', 'huber-plugin' ),
						'description' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber-plugin' ) . ' <a href="https://ghostpool.ticksy.com/article/10923" target="_blank">'. esc_html__( 'here', 'huber-plugin' ) . '</a>.',
						'param_name' => 'image_size_standard',
						'value' => ghostpool_image_sizes_vc_options(),
						'type' => 'dropdown',
						),						
						array( 
						'heading' => esc_html__( 'Hub Image Size', 'huber-plugin' ),
						'description' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber-plugin' ) . ' <a href="https://ghostpool.ticksy.com/article/10923" target="_blank">'. esc_html__( 'here', 'huber-plugin' ) . '</a>.',
						'param_name' => 'image_size_hub',
						'value' => ghostpool_image_sizes_vc_options(),
						'type' => 'dropdown',
						),						
						array( 
						'heading' => esc_html__( 'Review Image Size', 'huber-plugin' ),
						'description' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber-plugin' ) . ' <a href="https://ghostpool.ticksy.com/article/10923" target="_blank">'. esc_html__( 'here', 'huber-plugin' ) . '</a>.',
						'param_name' => 'image_size_review',
						'value' => ghostpool_image_sizes_vc_options(),
						'type' => 'dropdown',
						),						
						array( 
						'heading' => esc_html__( 'Preview Image Size', 'huber-plugin' ),
						'description' => esc_html__( 'Choose from one of the default image sizes or you can register your own image size as explained', 'huber-plugin' ) . ' <a href="https://ghostpool.ticksy.com/article/10923" target="_blank">'. esc_html__( 'here', 'huber-plugin' ) . '</a>.',
						'param_name' => 'image_size_preview',
						'value' => ghostpool_image_sizes_vc_options(),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Content Display', 'huber-plugin' ),
						'description' => esc_html__( 'The amount of content displayed.', 'huber-plugin' ),
						'param_name' => 'content_display',
						'value' => array( esc_html__( 'Excerpt', 'huber-plugin' ) => 'excerpt', esc_html__( 'Full Content', 'huber-plugin' ) => 'full_content' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Excerpt Length', 'huber-plugin' ),
						'description' => esc_html__( 'The number of characters in excerpts.', 'huber-plugin' ),
						'param_name' => 'excerpt_length',
						'value' => '160',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'content_display', 'value' => 'excerpt' ),
						),	
						array(
						'heading' => esc_html__( 'Post Meta', 'huber-plugin' ),
						'param_name' => 'meta_release_date',
						'value' => array( esc_html__( 'Release Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'meta_author',
						'value' => array( esc_html__( 'Author Name', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'meta_date',
						'value' => array( esc_html__( 'Post Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'meta_comment_count',
						'value' => array( esc_html__( 'Comment Count', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'meta_views',
						'value' => array( esc_html__( 'Views', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'meta_likes',
						'value' => array( esc_html__( 'Likes', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'meta_followers',
						'value' => array( esc_html__( 'Followers', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array( 
						'param_name' => 'meta_cats',
						'value' => array( esc_html__( 'Post Categories', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),						
						array(
						'param_name' => 'meta_tags',
						'value' => array( esc_html__( 'Post Tags', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),		
						array(
						'param_name' => 'meta_hub_fields',
						'value' => array( esc_html__( 'Hub Fields', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),		
						array(
						'param_name' => 'meta_site_rating',
						'value' => array( esc_html__( 'Site Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),		
						array(
						'param_name' => 'meta_user_rating',
						'value' => array( esc_html__( 'User Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						'description' => esc_html__( 'Select the meta data you want to display.', 'huber-plugin' ),
						),
						array(
						'heading' => esc_html__( 'Filters (Sorting)', 'huber-plugin' ),
						'param_name' => 'filter_date',
						'value' => array( esc_html__( 'Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'filter_title',
						'value' => array( esc_html__( 'Title', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),								
						array(
						'param_name' => 'filter_comment_count',
						'value' => array( esc_html__( 'Comment Count', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'filter_views',
						'value' => array( esc_html__( 'Views', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'filter_likes',
						'value' => array( esc_html__( 'Likes', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),						
						array(
						'param_name' => 'filter_release_date',
						'value' => array( esc_html__( 'Latest Releases', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),						
						array(
						'param_name' => 'filter_release_date_asc',
						'value' => array( esc_html__( 'Oldest Releases', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),							
						array(
						'param_name' => 'filter_site_rating',
						'value' => array( esc_html__( 'Top Site Rated', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),							
						array(
						'param_name' => 'filter_user_rating',
						'value' => array( esc_html__( 'Top User Rated', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						'description' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber-plugin' ),
						),
						array( 
						'heading' => esc_html__( 'Filter (Categories)', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the slug or ID of the category you want to filter by, leave blank to display all categories - the sub categories of this category will also be displayed.', 'huber-plugin' ),
						'param_name' => 'filter_cat_id',
						'type' => 'textfield',
						),																	
						array( 
						'heading' => esc_html__( 'Read More Link', 'huber-plugin' ),
						'description' => esc_html__( 'Add a read more link below the content.', 'huber-plugin' ),
						'param_name' => 'read_more_link',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),		 
						array( 
						'heading' => esc_html__( 'Pagination (Arrows)', 'huber-plugin' ),
						'description' => esc_html__( 'Add pagination arrows.', 'huber-plugin' ),
						'param_name' => 'page_arrows',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Pagination', 'huber-plugin' ),
						'description' => esc_html__( 'Add pagination numbers or load more button (filters disabled if using load more button).', 'huber-plugin' ),
						'param_name' => 'pagination',
						'value' => array( esc_html__( 'Page Numbers', 'huber-plugin' ) => 'page-numbers', esc_html__( 'Load More Button', 'huber-plugin' ) => 'load-more', esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'See All', 'huber-plugin' ),
						'description' => esc_html__( 'Add a "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'See All Link', 'huber-plugin' ),
						'description' => esc_html__( 'URL for the "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all_link',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'see_all', 'value' => 'enabled' ),
						),				 			 
						array( 
						'heading' => esc_html__( 'See All Text', 'huber-plugin' ),
						'description' => esc_html__( 'Custom text for the "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all_text',
						'type' => 'textfield',
						'value' => esc_html__( 'See All Items', 'huber-plugin' ),
						'dependency' => array( 'element' => 'see_all', 'value' => 'enabled' ),
						),		 				 		   			 			 
						array( 
						'heading' => esc_html__( 'Extra Class Names', 'huber-plugin' ),
						'description' => esc_html__( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'huber-plugin' ),
						'param_name' => 'classes',
						'value' => '',
						'type' => 'textfield',
						),		
						array( 
						'heading' => esc_html__( 'Title Icon Color', 'huber-plugin' ),
						'param_name' => 'icon_color',
						'value' => '#ffffff',
						'description' => esc_html__( 'The color of the icon.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),		
						array( 
						'heading' => esc_html__( 'Title Icon Background Color', 'huber-plugin' ),
						'param_name' => 'icon_bg_color',
						'value' => '#fe4a49',
						'description' => esc_html__( 'The background color of the icon.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),	
						array( 
						'heading' => esc_html__( 'Title Icon', 'huber-plugin' ),
						'param_name' => 'icon',
						'value' => $icons,
						'description' => esc_html__( 'The icon you want to display next to the title.', 'huber-plugin' ),
						'type' => 'icon_selection',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),	
						array( 
						'heading' => esc_html__( 'Title Color', 'huber-plugin' ),
						'param_name' => 'title_color',
						'value' => '',
						'description' => esc_html__( 'The title color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),							
						array( 
						'heading' => esc_html__( 'Post Title Color', 'huber-plugin' ),
						'param_name' => 'post_title_color',
						'value' => '',
						'description' => esc_html__( 'The post title color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),							
						array( 
						'heading' => esc_html__( 'Post Title Hover Color', 'huber-plugin' ),
						'param_name' => 'post_title_hover_color',
						'value' => '',
						'description' => esc_html__( 'The post title hover color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),	
						array( 
						'heading' => esc_html__( 'Post Link Color', 'huber-plugin' ),
						'param_name' => 'post_link_color',
						'value' => '',
						'description' => esc_html__( 'The post link color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),								
						array( 
						'heading' => esc_html__( 'Post Link Hover Color', 'huber-plugin' ),
						'param_name' => 'post_link_hover_color',
						'value' => '',
						'description' => esc_html__( 'The post link hover color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),									
						array( 
						'heading' => esc_html__( 'Post Text Color', 'huber-plugin' ),
						'param_name' => 'post_text_color',
						'value' => '',
						'description' => esc_html__( 'The post text color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),
						array( 
						'heading' => esc_html__( 'Meta Text Color', 'huber-plugin' ),
						'param_name' => 'meta_text_color',
						'value' => '',
						'description' => esc_html__( 'The meta text color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),
						array( 
						'heading' => esc_html__( 'Ranking Background Color', 'aardvark-plugin' ),
						'param_name' => 'ranking_bg_color',
						'value' => '',
						'description' => esc_html__( 'The ranking background color.', 'aardvark-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'aardvark-plugin' ),
						),		
						array( 
						'heading' => esc_html__( 'Ranking Text Color', 'aardvark-plugin' ),
						'param_name' => 'ranking_text_color',
						'value' => '',
						'description' => esc_html__( 'The ranking text color.', 'aardvark-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'aardvark-plugin' ),
						),			
																																												
					 )
				) );
		
										
				/*--------------------------------------------------------------
				Carousel Shortcode
				--------------------------------------------------------------*/

				require_once( sprintf( "%s/gp_vc_carousel.php", dirname( __FILE__ ) ) );
		
				vc_map( array( 
					'name' => esc_html__( 'Carousel', 'huber-plugin' ),
					'base' => 'carousel',
					'description' => esc_html__( 'Display a carousel.', 'huber-plugin' ),
					'class' => 'wpb_vc_carousel',
					'controls' => 'full',
					'icon' => 'gp-icon-carousel',
					'category' => esc_html__( 'Content', 'huber-plugin' ),
					'front_enqueue_js' => $flexslider_js,
					'admin_enqueue_css' => $admin_css,
					'params' => array(				
						array( 
						'heading' => esc_html__( 'Title', 'huber-plugin' ),
						'description' => esc_html__( 'The title at the top of the element.', 'huber-plugin' ),
						'param_name' => 'widget_title',
						'type' => 'textfield',
						'admin_label' => true,
						'value' => '',
						),		
						array( 
						'heading' => esc_html__( 'Categories', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the slugs or IDs separating each one with a comma e.g. xbox,ps3,pc.', 'huber-plugin' ),
						'param_name' => 'cats',
						'type' => 'textfield',
						),					
						array( 
						'heading' => esc_html__( 'Hub Fields', 'huber-plugin' ),
						'description' => wp_kses( __( 'Enter the hub fields you want to filter by. Add the taxonomy slug followed by a colon. Next enter the terms separating each by a colon also. Next add a comma and then enter the next taxonomy and so on e.g. <code>taxonomy-1:term-1:term-2,taxonomy-2:term-1,taxonomy-3:term-1:term-2</code>, this would translate to <code>genre:action:role-playing,publisher:namco,developed-by:namco:bluepoint-games</code>', 'huber-plugin' ), array( 'code' => array() ) ),
						'param_name' => 'hub_fields',
						'type' => 'textfield',
						'value' => '',
						),					
						array( 
						'heading' => esc_html__( 'Page IDs', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the IDs of the pages you want to include, separating each with a comma e.g. 48,142.', 'huber-plugin' ),
						'param_name' => 'page_ids',
						'type' => 'textfield',
						),			
						array( 
						'heading' => esc_html__( 'Post Types', 'huber-plugin' ),
						'description' => esc_html__( 'Separate each post type with a comma e.g. post, page.', 'huber-plugin' ),
						'param_name' => 'post_types',
						'type' => 'posttypes',
						'value' => 'post',
						),					
						array( 
						'heading' => esc_html__( 'Post Association', 'huber-plugin' ),
						'description' => esc_html__( 'Choose whether to only show items associated with the hub this is added to.', 'huber-plugin' ),
						'param_name' => 'post_association',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),		
						array( 
						'heading' => esc_html__( 'Order By', 'huber-plugin' ),
						'description' => esc_html__( 'The criteria which the items are ordered by.', 'huber-plugin' ),
						'param_name' => 'orderby',
						'value' => array(
							esc_html__( 'Newest', 'huber-plugin' ) => 'newest',
							esc_html__( 'Oldest', 'huber-plugin' ) => 'oldest',
							esc_html__( 'Title (A-Z)', 'huber-plugin' ) => 'title_az',
							esc_html__( 'Title (Z-A)', 'huber-plugin' ) => 'title_za',
							esc_html__( 'Most Comments', 'huber-plugin' ) => 'comment_count',
							esc_html__( 'Most Views', 'huber-plugin' ) => 'views',
							esc_html__( 'Most Likes', 'huber-plugin' ) => 'likes',
							esc_html__( 'Menu Order', 'huber-plugin' ) => 'menu_order',
							esc_html__( 'Random', 'huber-plugin' ) => 'rand',
							esc_html__( 'Latest Releases', 'huber-plugin' ) => 'release_date',
							esc_html__( 'Oldest Releases', 'huber-plugin' ) => 'release_date_asc',
							esc_html__( 'Top Site Rated', 'huber-plugin' ) => 'site_rating',
							esc_html__( 'Top User Rated', 'huber-plugin' ) => 'user_rating',
						),
						'type' => 'dropdown',
						),		
						array( 
						'heading' => esc_html__( 'Release Date From', 'huber-plugin' ),
						'description' => esc_html__( 'Enter "today" to use today\'s date e.g. only displays items with a release date later than today\'s date.', 'huber-plugin' ),
						'param_name' => 'release_date_from',
						'type' => 'date_picker',
						),
						array( 
						'heading' => esc_html__( 'Release Date To', 'huber-plugin' ),
						'description' => esc_html__( 'Enter "today" to use today\'s date e.g. only displays items with a release date with today\'s date and earlier.', 'huber-plugin' ),
						'param_name' => 'release_date_to',
						'type' => 'date_picker',
						),	
						array( 
						'heading' => esc_html__( 'Items In View', 'huber-plugin' ),
						'description' => esc_html__( 'The number of items in view at one time.', 'huber-plugin' ),
						'param_name' => 'items_in_view',
						'value' => '3',
						'type' => 'textfield',
						),								 
						array( 
						'heading' => esc_html__( 'Total Items', 'huber-plugin' ),
						'description' => esc_html__( 'The total number of items.', 'huber-plugin' ),
						'param_name' => 'per_page',
						'value' => '12',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Offset', 'huber-plugin' ),
						'description' => esc_html__( 'The number of items to offset by e.g. set to 3 to exclude the first 3 posts.', 'huber-plugin' ),
						'param_name' => 'offset',
						'value' => '',
						'type' => 'textfield',
						),
						array(
						'heading' => esc_html__( 'Post Meta', 'huber-plugin' ),
						'param_name' => 'meta_site_rating',
						'value' => array( esc_html__( 'Site Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),			
						array(
						'param_name' => 'meta_user_rating',
						'value' => array( esc_html__( 'User Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						'description' => esc_html__( 'Select the meta data you want to display.', 'huber-plugin' ),
						),			
						array( 
						'heading' => esc_html__( 'Carousel Speed', 'huber-plugin' ),
						'description' => esc_html__( 'The number of seconds before the carousel goes to the next set of items.', 'huber-plugin' ),
						'param_name' => 'slider_speed',
						'value' => '0',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Animation Speed', 'huber-plugin' ),
						'description' => esc_html__( 'The speed of the carousel animation in seconds.', 'huber-plugin' ),
						'param_name' => 'animation_speed',
						'value' => '0.6',
						'type' => 'textfield',		
						),	
						array( 
						'heading' => esc_html__( 'Navigation Buttons', 'huber-plugin' ),
						'description' => esc_html__( 'Display the carousel navigation buttons.', 'huber-plugin' ),
						'param_name' => 'buttons',
						'value' => array(
							esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled',
							esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled',
						),
						'type' => 'dropdown',
						),					
						array( 
						'heading' => esc_html__( 'Navigation Arrows', 'huber-plugin' ),
						'description' => esc_html__( 'Display the carousel navigation arrows.', 'huber-plugin' ),
						'param_name' => 'arrows',
						'value' => array(
							esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled',
							esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled',
						),
						'type' => 'dropdown',
						),				
						array( 
						'heading' => esc_html__( 'See All', 'huber-plugin' ),
						'description' => esc_html__( 'Add a "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'See All Link', 'huber-plugin' ),
						'description' => esc_html__( 'URL for the "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all_link',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'see_all', 'value' => 'enabled' ),
						),				 			 
						array( 
						'heading' => esc_html__( 'See All Text', 'huber-plugin' ),
						'description' => esc_html__( 'Custom text for the "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all_text',
						'type' => 'textfield',
						'value' => esc_html__( 'See All Items', 'huber-plugin' ),
						'dependency' => array( 'element' => 'see_all', 'value' => 'enabled' ),
						),	 			 				 		   			 			 
						array( 
						'heading' => esc_html__( 'Extra Class Names', 'huber-plugin' ),
						'description' => esc_html__( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'huber-plugin' ),
						'param_name' => 'classes',
						'value' => '',
						'type' => 'textfield',
						),	
						array( 
						'heading' => esc_html__( 'Title Icon Color', 'huber-plugin' ),
						'param_name' => 'icon_color',
						'value' => '#ffffff',
						'description' => esc_html__( 'The color of the icon.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),		
						array( 
						'heading' => esc_html__( 'Title Icon Background Color', 'huber-plugin' ),
						'param_name' => 'icon_bg_color',
						'value' => '#fe4a49',
						'description' => esc_html__( 'The background color of the icon.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),	
						array( 
						'heading' => esc_html__( 'Title Icon', 'huber-plugin' ),
						'param_name' => 'icon',
						'value' => $icons,
						'description' => esc_html__( 'The icon you want to display next to the title.', 'huber-plugin' ),
						'type' => 'icon_selection',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),					
						array( 
						'heading' => esc_html__( 'Title Color', 'huber-plugin' ),
						'param_name' => 'title_color',
						'value' => '',
						'description' => esc_html__( 'The title color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),							
						array( 
						'heading' => esc_html__( 'Post Title Color', 'huber-plugin' ),
						'param_name' => 'post_title_color',
						'value' => '',
						'description' => esc_html__( 'The post title color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),							
						array( 
						'heading' => esc_html__( 'Post Title Hover Color', 'huber-plugin' ),
						'param_name' => 'post_title_hover_color',
						'value' => '',
						'description' => esc_html__( 'The post title hover color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),								
						array( 
						'heading' => esc_html__( 'Post Link Color', 'huber-plugin' ),
						'param_name' => 'post_link_color',
						'value' => '',
						'description' => esc_html__( 'The post link color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),								
						array( 
						'heading' => esc_html__( 'Post Link Hover Color', 'huber-plugin' ),
						'param_name' => 'post_link_hover_color',
						'value' => '',
						'description' => esc_html__( 'The post link hover color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),									
						array( 
						'heading' => esc_html__( 'Post Text Color', 'huber-plugin' ),
						'param_name' => 'post_text_color',
						'value' => '',
						'description' => esc_html__( 'The post text color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),
						array( 
						'heading' => esc_html__( 'Meta Text Color', 'huber-plugin' ),
						'param_name' => 'meta_text_color',
						'value' => '',
						'description' => esc_html__( 'The meta text color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),																																																		
					 )
				) );


				/*--------------------------------------------------------------
				Pricing Table Shortcode
				--------------------------------------------------------------*/

				// Pricing Table
				vc_map( array( 
					'name' => esc_html__( 'Pricing Table', 'huber-plugin' ),
					'base' => 'pricing_table',
					'description' => esc_html__( 'A table to compare the prices of different items.', 'huber-plugin' ),
					'as_parent' => array( 'only' => 'pricing_column' ),
					'controls' => 'full',
					'icon' => 'gp-icon-pricing-table',
					'category' => esc_html__( 'Content', 'huber-plugin' ),
					'js_view' => 'VcColumnView',
					'params' => array( 
						array( 
						'heading' => esc_html__( 'Extra Class Names', 'huber-plugin' ),
						'param_name' => 'classes',
						'value' => '',
						'description' => esc_html__( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'huber-plugin' ),
						'type' => 'textfield',
						),	
					),
					'js_view' => 'VcColumnView'
				 ) );


				// Pricing Column
				vc_map( array( 
					'name' => esc_html__( 'Pricing Column', 'huber-plugin' ),
					'base' => 'pricing_column',
					'content_element' => true,
					'as_child' => array( 'only' => 'pricing_table' ),
					'icon' => 'gp-icon-pricing-table',
					'params' => array( 	
						array( 
						'heading' => esc_html__( 'Column Title', 'huber-plugin' ),
						'description' => esc_html__( 'The title for the column.', 'huber-plugin' ),
						'param_name' => 'title',
						'value' => '',
						'type' => 'textfield'
						),
						array( 
						'heading' => esc_html__( 'Price', 'huber-plugin' ),
						'description' => esc_html__( 'The price for the column.', 'huber-plugin' ),
						'param_name' => 'price',
						'value' => '',
						'type' => 'textfield'
						),
						array( 
						'heading' => esc_html__( 'Currency Symbol', 'huber-plugin' ),
						'description' => esc_html__( 'The currency symbol.', 'huber-plugin' ),
						'param_name' => 'currency_symbol',
						'value' => '',
						'type' => 'textfield',
						),		
						array( 
						'heading' => esc_html__( 'Interval', 'huber-plugin' ),
						'description' => esc_html__( 'The interval for the column e.g. per week, per month.', 'huber-plugin' ),
						'param_name' => 'interval',
						'value' => '',
						'type' => 'textfield',
						),		
						array( 
						'heading' => esc_html__( 'Highlight Column', 'huber-plugin' ),
						'description' => esc_html__( 'Make this column stand out.', 'huber-plugin' ),
						'param_name' => 'highlight',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown'
						),	
						array( 
						'heading' => esc_html__( 'Highlight Text', 'huber-plugin' ),
						'description' => esc_html__( 'Add highlight text above the column title.', 'huber-plugin' ),
						'param_name' => 'highlight_text',
						'value' => '',
						'dependency' => array( 'element' => 'highlight', 'value' => 'enabled' ),
						'type' => 'textfield',
						),	
						array( 
						'heading' => esc_html__( 'Content', 'huber-plugin' ),
						'description' => esc_html__( 'Use the Unordered List button to create the points in your pricing column. You can also add shortcodes such as the [button link="#"] shortcode seen in the site demo.', 'huber-plugin' ),
						'param_name' => 'content',
						'type' => 'textarea_html',
						),
						array( 
						'heading' => esc_html__( 'Highlight Color', 'huber-plugin' ),
						'description' => esc_html__( 'The highlight color.', 'huber-plugin' ),
						'param_name' => 'highlight_color',
						'value' => '#f84103',
						'dependency' => array( 'element' => 'highlight', 'value' => 'enabled' ),
						'type' => 'colorpicker',
						),		
						array( 
						'heading' => esc_html__( 'Title Color', 'huber-plugin' ),
						'description' => esc_html__( 'The title color.', 'huber-plugin' ),
						'param_name' => 'title_color',
						'value' => '#f84103',
						'dependency' => array( 'element' => 'highlight', 'value' => 'disabled' ),
						'type' => 'colorpicker',
						),	
						array( 
						'heading' => esc_html__( 'Highlight Title Color', 'huber-plugin' ),
						'description' => esc_html__( 'The highlight title color.', 'huber-plugin' ),
						'param_name' => 'highlight_title_color',
						'value' => '#fff',
						'dependency' => array( 'element' => 'highlight', 'value' => 'enabled' ),
						'type' => 'colorpicker',
						),	
						array( 
						'heading' => esc_html__( 'Background Color', 'huber-plugin' ),
						'description' => esc_html__( 'The background color.', 'huber-plugin' ),
						'param_name' => 'background_color',
						'value' => '#f7f7f7',
						'dependency' => array( 'element' => 'highlight', 'value' => 'disabled' ),
						'type' => 'colorpicker',
						),		 
						array( 
						'heading' => esc_html__( 'Highlight Background Color', 'huber-plugin' ),
						'description' => esc_html__( 'The highlight background color.', 'huber-plugin' ),
						'param_name' => 'highlight_background_color',
						'value' => '#fff',
						'dependency' => array( 'element' => 'highlight', 'value' => 'enabled' ),
						'type' => 'colorpicker',
						),		 		 		 
						array( 
						'heading' => esc_html__( 'Text Color', 'huber-plugin' ),
						'description' => esc_html__( 'The text color.', 'huber-plugin' ),
						'param_name' => 'text_color',
						'value' => '#747474',
						'type' => 'colorpicker',
						),	
						array( 
						'heading' => esc_html__( 'Border', 'huber-plugin' ),
						'description' => esc_html__( 'Add a border around the columns.', 'huber-plugin' ),
						'param_name' => 'border',
						'value' => array( esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled', esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled' ),
						'type' => 'dropdown',
						),			 
						array( 
						'heading' => esc_html__( 'Border Color', 'huber-plugin' ),
						'description' => esc_html__( 'The border color.', 'huber-plugin' ),
						'param_name' => 'border_color',
						'value' => '#e7e7e7',
						'dependency' => array( 'element' => 'border', 'value' => 'enabled' ),
						'type' => 'colorpicker',
						),	 		 																																							
					 )
				 ) );
			 			 
				/*--------------------------------------------------------------
				Showcase Shortcode
				--------------------------------------------------------------*/

				require_once( sprintf( "%s/gp_vc_showcase.php", dirname( __FILE__ ) ) );

				vc_map( array( 
					'name' => esc_html__( 'Showcase', 'huber-plugin' ),
					'base' => 'showcase',
					'description' => esc_html__( 'Horizontal and vertical content formats.', 'huber-plugin' ),
					'class' => 'wpb_vc_showcase',
					'controls' => 'full',
					'icon' => 'gp-icon-showcase',
					'category' => esc_html__( 'Content', 'huber-plugin' ),			
					'admin_enqueue_css' => $admin_css,
					'front_enqueue_css' => $admin_css,
					'params' => array(		
						array( 
						'heading' => esc_html__( 'Title', 'huber-plugin' ),
						'description' => esc_html__( 'The title at the top of the element.', 'huber-plugin' ),
						'param_name' => 'widget_title',
						'type' => 'textfield',
						'admin_label' => true,
						'value' => '',
						),		 									
						array( 
						'heading' => esc_html__( 'Categories', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the slugs or IDs separating each one with a comma e.g. xbox,ps3,pc.', 'huber-plugin' ),
						'param_name' => 'cats',
						'type' => 'textfield',
						),					
						array( 
						'heading' => esc_html__( 'Hub Fields', 'huber-plugin' ),
						'description' => wp_kses( __( 'Enter the hub fields you want to filter by. Add the taxonomy slug followed by a colon. Next enter the terms separating each by a colon also. Next add a comma and then enter the next taxonomy and so on e.g. <code>taxonomy-1:term-1:term-2,taxonomy-2:term-1,taxonomy-3:term-1:term-2</code>, this would translate to <code>genre:action:role-playing,publisher:namco,developed-by:namco:bluepoint-games</code>', 'huber-plugin' ), array( 'code' => array() ) ),
						'param_name' => 'hub_fields',
						'type' => 'textfield',
						'value' => '',
						),				
						array( 
						'heading' => esc_html__( 'Page IDs', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the IDs of the pages you want to include, separating each with a comma e.g. 48,142.', 'huber-plugin' ),
						'param_name' => 'page_ids',
						'type' => 'textfield',
						),			
						array( 
						'heading' => esc_html__( 'Post Types', 'huber-plugin' ),
						'description' => esc_html__( 'Separate each post type with a comma e.g. post, page.', 'huber-plugin' ),
						'param_name' => 'post_types',
						'type' => 'posttypes',
						'value' => 'post',
						),					
						array( 
						'heading' => esc_html__( 'Post Association', 'huber-plugin' ),
						'description' => esc_html__( 'Choose whether to only show items associated with the hub this is added to.', 'huber-plugin' ),
						'param_name' => 'post_association',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),		
						array( 
						'heading' => esc_html__( 'Ranking', 'huber-plugin' ),
						'description' => esc_html__( 'Add ranking numbers to your items', 'huber-plugin' ),
						'param_name' => 'ranking',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'gp-no-ranking', esc_html__( 'Enabled', 'huber-plugin' ) => 'gp-ranking' ),
						'type' => 'dropdown',
						),	
						array( 
						'heading' => esc_html__( 'Format', 'huber-plugin' ),
						'description' => esc_html__( 'The format to display the items in.', 'huber-plugin' ),
						'param_name' => 'format',
						'value' => array( esc_html__( 'Horizontal Showcase', 'huber-plugin' ) => 'gp-blog-horizontal', esc_html__( 'Vertical Showcase', 'huber-plugin' ) => 'gp-blog-vertical' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Order By', 'huber-plugin' ),
						'description' => esc_html__( 'The criteria which the items are ordered by.', 'huber-plugin' ),
						'param_name' => 'orderby',
						'value' => array(
							esc_html__( 'Newest', 'huber-plugin' ) => 'newest',
							esc_html__( 'Oldest', 'huber-plugin' ) => 'oldest',
							esc_html__( 'Title (A-Z)', 'huber-plugin' ) => 'title_az',
							esc_html__( 'Title (Z-A)', 'huber-plugin' ) => 'title_za',
							esc_html__( 'Most Comments', 'huber-plugin' ) => 'comment_count',
							esc_html__( 'Most Views', 'huber-plugin' ) => 'views',
							esc_html__( 'Most Likes', 'huber-plugin' ) => 'likes',
							esc_html__( 'Menu Order', 'huber-plugin' ) => 'menu_order',
							esc_html__( 'Random', 'huber-plugin' ) => 'rand',
							esc_html__( 'Latest Releases', 'huber-plugin' ) => 'release_date',
							esc_html__( 'Oldest Releases', 'huber-plugin' ) => 'release_date_asc',
							esc_html__( 'Top Site Rated', 'huber-plugin' ) => 'site_rating',
							esc_html__( 'Top User Rated', 'huber-plugin' ) => 'user_rating',
						),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Release Date From', 'huber-plugin' ),
						'description' => esc_html__( 'Enter "today" to use today\'s date e.g. only displays items with a release date later than today\'s date.', 'huber-plugin' ),
						'param_name' => 'release_date_from',
						'type' => 'date_picker',
						),
						array( 
						'heading' => esc_html__( 'Release Date To', 'huber-plugin' ),
						'description' => esc_html__( 'Enter "today" to use today\'s date e.g. only displays items with a release date with today\'s date and earlier.', 'huber-plugin' ),
						'param_name' => 'release_date_to',
						'type' => 'date_picker',
						),										 
						array( 
						'heading' => esc_html__( 'Items Per Page', 'huber-plugin' ),
						'description' => esc_html__( 'The number of items on each page.', 'huber-plugin' ),
						'param_name' => 'per_page',
						'value' => '5',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Offset', 'huber-plugin' ),
						'description' => esc_html__( 'The number of items to offset by e.g. set to 3 to exclude the first 3 posts.', 'huber-plugin' ),
						'param_name' => 'offset',
						'value' => '',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Large Excerpt Length', 'huber-plugin' ),
						'description' => esc_html__( 'The number of characters in large excerpts.', 'huber-plugin' ),
						'param_name' => 'large_excerpt_length',
						'value' => '80',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Small Excerpt Length', 'huber-plugin' ),
						'description' => esc_html__( 'The number of characters in small excerpts.', 'huber-plugin' ),
						'param_name' => 'small_excerpt_length',
						'value' => '0',
						'type' => 'textfield',
						),		
						array(
						'heading' => esc_html__( 'Large Post Meta', 'huber-plugin' ),
						'param_name' => 'large_meta_release_date',
						'value' => array( esc_html__( 'Release Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),			
						array(
						'param_name' => 'large_meta_author',
						'value' => array( esc_html__( 'Author Name', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'large_meta_date',
						'value' => array( esc_html__( 'Post Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),		
						array(
						'param_name' => 'large_meta_comment_count',
						'value' => array( esc_html__( 'Comment Count', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'large_meta_views',
						'value' => array( esc_html__( 'Views', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'large_meta_likes',
						'value' => array( esc_html__( 'Likes', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),		
						array(
						'param_name' => 'large_meta_followers',
						'value' => array( esc_html__( 'Followers', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array( 
						'param_name' => 'large_meta_cats',
						'value' => array( esc_html__( 'Post Categories', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'large_meta_tags',
						'value' => array( esc_html__( 'Post Tags', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'large_meta_hub_fields',
						'value' => array( esc_html__( 'Hub Fields', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'large_meta_site_rating',
						'value' => array( esc_html__( 'Site Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'large_meta_user_rating',
						'value' => array( esc_html__( 'User Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						'description' => esc_html__( 'Select the large meta data you want to display.', 'huber-plugin' ),
						),
						array(
						'heading' => esc_html__( 'Small Post Meta', 'huber-plugin' ),
						'param_name' => 'small_meta_release_date',
						'value' => array( esc_html__( 'Release Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'small_meta_author',
						'value' => array( esc_html__( 'Author Name', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'small_meta_date',
						'value' => array( esc_html__( 'Post Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),		
						array(
						'param_name' => 'small_meta_comment_count',
						'value' => array( esc_html__( 'Comment Count', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'small_meta_views',
						'value' => array( esc_html__( 'Views', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'small_meta_likes',
						'value' => array( esc_html__( 'Likes', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),			
						array(
						'param_name' => 'small_meta_followers',
						'value' => array( esc_html__( 'Followers', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array( 
						'param_name' => 'small_meta_cats',
						'value' => array( esc_html__( 'Post Categories', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'small_meta_tags',
						'value' => array( esc_html__( 'Post Tags', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'small_meta_hub_fields',
						'value' => array( esc_html__( 'Hub Fields', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'small_meta_site_rating',
						'value' => array( esc_html__( 'Site Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'small_meta_user_rating',
						'value' => array( esc_html__( 'User Rating', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						'description' => esc_html__( 'Select the small meta data you want to display.', 'huber-plugin' ),
						),

						array( 
						'heading' => esc_html__( 'Filters (Sorting)', 'huber-plugin' ),
						'param_name' => 'filter_date',
						'value' => array( esc_html__( 'Date', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'filter_title',
						'value' => array( esc_html__( 'Title', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),								
						array(
						'param_name' => 'filter_comment_count',
						'value' => array( esc_html__( 'Comment Count', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),
						array(
						'param_name' => 'filter_views',
						'value' => array( esc_html__( 'Views', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),	
						array(
						'param_name' => 'filter_likes',
						'value' => array( esc_html__( 'Likes', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),						
						array(
						'param_name' => 'filter_release_date',
						'value' => array( esc_html__( 'Latest Releases', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),						
						array(
						'param_name' => 'filter_release_date_asc',
						'value' => array( esc_html__( 'Oldest Releases', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),							
						array(
						'param_name' => 'filter_site_rating',
						'value' => array( esc_html__( 'Top Site Rated', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						),							
						array(
						'param_name' => 'filter_user_rating',
						'value' => array( esc_html__( 'Top User Rated', 'huber-plugin' ) => '1' ),
						'type' => 'checkbox',
						'description' => esc_html__( 'Choose what options to display in the frontend dropdown filter menu (disabled if load more button enabled).', 'huber-plugin' ),
						),		
						array( 
						'heading' => esc_html__( 'Filter (Categories)', 'huber-plugin' ),
						'description' => esc_html__( 'Enter the slug or ID of the category you want to filter by, leave blank to display all categories - the sub categories of this category will also be displayed.', 'huber-plugin' ),
						'param_name' => 'filter_cat_id',
						'type' => 'textfield',
						),													
						array( 
						'heading' => esc_html__( 'Large Read More Link', 'huber-plugin' ),
						'description' => esc_html__( 'Add a read more link below the large content.', 'huber-plugin' ),
						'param_name' => 'large_read_more_link',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),												
						array( 
						'heading' => esc_html__( 'Small Read More Link', 'huber-plugin' ),
						'description' => esc_html__( 'Add a read more link below the small content.', 'huber-plugin' ),
						'param_name' => 'small_read_more_link',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Pagination (Arrows)', 'huber-plugin' ),
						'description' => esc_html__( 'Add pagination arrows.', 'huber-plugin' ),
						'param_name' => 'page_arrows',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'Pagination (Numbers)', 'huber-plugin' ),
						'description' => esc_html__( 'Add pagination numbers.', 'huber-plugin' ),
						'param_name' => 'pagination',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'page-numbers' ),
						'type' => 'dropdown',
						),						
						array( 
						'heading' => esc_html__( 'See All', 'huber-plugin' ),
						'description' => esc_html__( 'Add a "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all',
						'value' => array( esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled', esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled' ),
						'type' => 'dropdown',
						),
						array( 
						'heading' => esc_html__( 'See All Link', 'huber-plugin' ),
						'description' => esc_html__( 'URL for the "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all_link',
						'type' => 'textfield',
						'dependency' => array( 'element' => 'see_all', 'value' => 'enabled' ),
						),				 			 
						array( 
						'heading' => esc_html__( 'See All Text', 'huber-plugin' ),
						'description' => esc_html__( 'Custom text for the "See All" link.', 'huber-plugin' ),
						'param_name' => 'see_all_text',
						'type' => 'textfield',
						'value' => esc_html__( 'See All Items', 'huber-plugin' ),
						'dependency' => array( 'element' => 'see_all', 'value' => 'enabled' ),
						),	 			 				 		   			 			 
						array( 
						'heading' => esc_html__( 'Extra Class Names', 'huber-plugin' ),
						'description' => esc_html__( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'huber-plugin' ),
						'param_name' => 'classes',
						'value' => '',
						'type' => 'textfield',
						),	
						array( 
						'heading' => esc_html__( 'Title Icon Color', 'huber-plugin' ),
						'param_name' => 'icon_color',
						'value' => '#ffffff',
						'description' => esc_html__( 'The color of the icon.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),
						array( 
						'heading' => esc_html__( 'Title Icon Background Color', 'huber-plugin' ),
						'param_name' => 'icon_bg_color',
						'value' => '#fe4a49',
						'description' => esc_html__( 'The background color of the icon.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),
						array( 
						'heading' => esc_html__( 'Title Icon', 'huber-plugin' ),
						'param_name' => 'icon',
						'value' => $icons,
						'description' => esc_html__( 'The icon you want to display next to the title.', 'huber-plugin' ),
						'type' => 'icon_selection',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),						
						array( 
						'heading' => esc_html__( 'Title Color', 'huber-plugin' ),
						'param_name' => 'title_color',
						'value' => '',
						'description' => esc_html__( 'The title color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),							
						array( 
						'heading' => esc_html__( 'Post Title Color', 'huber-plugin' ),
						'param_name' => 'post_title_color',
						'value' => '',
						'description' => esc_html__( 'The post title color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),							
						array( 
						'heading' => esc_html__( 'Post Title Hover Color', 'huber-plugin' ),
						'param_name' => 'post_title_hover_color',
						'value' => '',
						'description' => esc_html__( 'The post title hover color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),	
						array( 
						'heading' => esc_html__( 'Post Link Color', 'huber-plugin' ),
						'param_name' => 'post_link_color',
						'value' => '',
						'description' => esc_html__( 'The post link color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),								
						array( 
						'heading' => esc_html__( 'Post Link Hover Color', 'huber-plugin' ),
						'param_name' => 'post_link_hover_color',
						'value' => '',
						'description' => esc_html__( 'The post link hover color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),									
						array( 
						'heading' => esc_html__( 'Post Text Color', 'huber-plugin' ),
						'param_name' => 'post_text_color',
						'value' => '',
						'description' => esc_html__( 'The post text color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),
						array( 
						'heading' => esc_html__( 'Meta Text Color', 'huber-plugin' ),
						'param_name' => 'meta_text_color',
						'value' => '',
						'description' => esc_html__( 'The meta text color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),									
						array( 
						'heading' => esc_html__( 'Post Border Color', 'huber-plugin' ),
						'param_name' => 'post_border_color',
						'value' => '',
						'description' => esc_html__( 'The post border color.', 'huber-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),	
						array( 
						'heading' => esc_html__( 'Ranking Background Color', 'aardvark-plugin' ),
						'param_name' => 'ranking_bg_color',
						'value' => '',
						'description' => esc_html__( 'The ranking background color.', 'aardvark-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'aardvark-plugin' ),
						),		
						array( 
						'heading' => esc_html__( 'Ranking Text Color', 'aardvark-plugin' ),
						'param_name' => 'ranking_text_color',
						'value' => '',
						'description' => esc_html__( 'The ranking text color.', 'aardvark-plugin' ),
						'type' => 'colorpicker',
						'group' => esc_html__( 'Design options', 'aardvark-plugin' ),
						),
																																																	
					 )
				) );
		
		
				/*--------------------------------------------------------------
				Team Shortcode
				--------------------------------------------------------------*/

				// Team Wrapper
				vc_map( array( 
					'name' => esc_html__( 'Team', 'huber-plugin' ),
					'base' => 'team',
					'description' => esc_html__( 'Display your team members.', 'huber-plugin' ),
					'as_parent' => array( 'only' => 'team_member' ), 
					'class' => 'wpb_vc_team',
					'controls' => 'full',
					'icon' => 'gp-icon-team',
					'category' => esc_html__( 'Content', 'huber-plugin' ),
					'js_view' => 'VcColumnView',
					'params' => array( 	
						array( 
						'heading' => esc_html__( 'Columns', 'huber-plugin' ),
						'param_name' => 'columns',
						'value' => '3',
						'description' => esc_html__( 'The number of columns.', 'huber-plugin' ),
						'type' => 'textfield',
						),		
						array( 
						'heading' => esc_html__( 'Extra Class Names', 'huber-plugin' ),
						'description' => esc_html__( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'huber-plugin' ),
						'param_name' => 'classes',
						'value' => '',
						'type' => 'textfield',
						),																																								
					 ),
					'js_view' => 'VcColumnView',
				) );

				// Team Member
				vc_map( array( 
					'name' => esc_html__( 'Team Member', 'huber-plugin' ),
					'base' => 'team_member',
					'icon' => 'gp-icon-team',
					'content_element' => true,
					'as_child' => array( 'only' => 'team' ),
					'params' => array( 	
						array( 
						'heading' => esc_html__( 'Image', 'huber-plugin' ),
						'description' => esc_html__( 'The team member image.', 'huber-plugin' ),
						'param_name' => 'image_url',
						'value' => '',
						'type' => 'attach_image'
						),
						array( 
						'heading' => esc_html__( 'Image Width', 'huber-plugin' ),
						'description' => esc_html__( 'The width of the team member image.', 'huber-plugin' ),
						'param_name' => 'image_width',
						'value' => '230',
						'type' => 'textfield',
						),		
						array( 
						'heading' => esc_html__( 'Image Height', 'huber-plugin' ),
						'description' => esc_html__( 'The height of the team member image.', 'huber-plugin' ),
						'param_name' => 'image_height',
						'value' => '230',
						'type' => 'textfield',
						),			
						array( 
						'heading' => esc_html__( 'Name', 'huber-plugin' ),
						'description' => esc_html__( 'The name of the team member.', 'huber-plugin' ),
						'param_name' => 'name',
						'admin_label' => true,
						'value' => '',
						'type' => 'textfield'
						),	
						array( 
						'heading' => esc_html__( 'Position', 'huber-plugin' ),
						'description' => esc_html__( 'The position of the team member e.g. CEO', 'huber-plugin' ),
						'param_name' => 'position',
						'value' => '',
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Link', 'huber-plugin' ),
						'description' => esc_html__( 'Add a link for the team member image.', 'huber-plugin' ),
						'param_name' => 'link',
						'value' => '',
						'type' => 'textfield',
						),	
						array( 
						'heading' => esc_html__( 'Link Target', 'huber-plugin' ),
						'description' => esc_html__( 'The link target for the team member image.', 'huber-plugin' ),
						'param_name' => 'link_target',
						'value' => array( esc_html__( 'Same Window', 'huber-plugin' ) => '_self', esc_html__( 'New Window', 'huber-plugin' ) => '_blank' ),
						'type' => 'dropdown',
						'dependency' => array( 'element' => 'link', 'not_empty' => true ),
						),				
						array( 
						'heading' => esc_html__( 'Description', 'huber-plugin' ),
						'description' => esc_html__( 'The description of the team member.', 'huber-plugin' ),
						'param_name' => 'content',
						'value' => '',
						'type' => 'textarea_html',
						),																																								
					 )
				 ) );
			 

				/*--------------------------------------------------------------
				Testimonials Shortcode
				--------------------------------------------------------------*/

				// Testimonial Slider
				vc_map( array( 
					'name' => esc_html__( 'Testimonial Slider', 'huber-plugin' ),
					'base' => 'testimonial_slider',
					'description' => esc_html__( 'Show your testimonials in a slider.', 'huber-plugin' ),
					'as_parent' => array( 'only' => 'testimonial' ), 
					'class' => 'wpb_vc_testimonial',
					'controls' => 'full',
					'icon' => 'gp-icon-testimonial-slider',
					'category' => esc_html__( 'Content', 'huber-plugin' ),
					'js_view' => 'VcColumnView',
					'params' => array( 	
						array( 
						'heading' => esc_html__( 'Effect', 'huber-plugin' ),
						'param_name' => 'effect',
						'value' => array( esc_html__( 'Slide', 'huber-plugin' ) => 'slide', esc_html__( 'Fade', 'huber-plugin' ) => 'fade' ),
						'description' => esc_html__( 'The slider effect.', 'huber-plugin' ),
						'type' => 'dropdown'
						),
						array( 
						'heading' => esc_html__( 'Slider Speed', 'huber-plugin' ),
						'param_name' => 'speed',
						'value' => '0',
						'description' => esc_html__( 'The number of seconds between slide transitions, set to 0 to disable the autoplay.', 'huber-plugin' ),
						'type' => 'textfield',
						),
						array( 
						'heading' => esc_html__( 'Buttons', 'huber-plugin' ),
						'param_name' => 'buttons',
						'value' => array( esc_html__( 'Hide', 'huber-plugin' ) => 'false', esc_html__( 'Show', 'huber-plugin' ) => 'true' ),
						'description' => esc_html__( 'The slider buttons.', 'huber-plugin' ),
						'type' => 'dropdown',
						),			
						array( 
						'heading' => esc_html__( 'Arrows', 'huber-plugin' ),
						'param_name' => 'arrows',
						'value' => array( esc_html__( 'Show', 'huber-plugin' ) => 'true', esc_html__( 'Hide', 'huber-plugin' ) => 'false' ),
						'description' => esc_html__( 'The slider arrows.', 'huber-plugin' ),
						'type' => 'dropdown',
						),			
						array( 
						'heading' => esc_html__( 'Extra Class Names', 'huber-plugin' ),
						'description' => esc_html__( 'If you wish to style this particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'huber-plugin' ),
						'param_name' => 'classes',
						'value' => '',
						'type' => 'textfield',
						),					
						array(
						'heading' => esc_html__( 'CSS', 'huber-plugin' ),
						'type' => 'css_editor',
						'param_name' => 'css',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),	
						array( 
						'heading' => esc_html__( 'Background Overlay', 'huber-plugin' ),
						'description' => esc_html__( 'Add a semi-transparent black background over your background image.', 'huber-plugin' ),
						'param_name' => 'background_overlay',
						'value' => array( esc_html__( 'Enabled', 'huber-plugin' ) => 'enabled', esc_html__( 'Disabled', 'huber-plugin' ) => 'disabled' ),
						'type' => 'dropdown',
						'group' => esc_html__( 'Design options', 'huber-plugin' ),
						),																																											
					 ),
					'js_view' => 'VcColumnView'
				 ) );

				// Testimonial Slide
				vc_map( array( 
					'name' => esc_html__( 'Testimonial', 'huber-plugin' ),
					'base' => 'testimonial',
					'content_element' => true,
					'as_child' => array( 'only' => 'testimonial_slider' ),
					'icon' => 'gp-icon-testimonial-slider',
					'params' => array( 	
						array( 
						'heading' => esc_html__( 'Image', 'huber-plugin' ),
						'description' => esc_html__( 'The testimonial slide image.', 'huber-plugin' ),
						'param_name' => 'image_url',
						'value' => '',
						'type' => 'attach_image'
						),
						array( 
						'heading' => esc_html__( 'Image Width', 'huber-plugin' ),
						'description' => esc_html__( 'The width the testimonial slide image.', 'huber-plugin' ),
						'param_name' => 'image_width',
						'value' => '100',
						'description' => '',
						'type' => 'textfield',
						),		
						array( 
						'heading' => esc_html__( 'Image Height', 'huber-plugin' ),
						'description' => esc_html__( 'The height of the testimonial slide images.', 'huber-plugin' ),
						'param_name' => 'image_height',
						'value' => '100',
						'type' => 'textfield',
						),		
						array( 
						'heading' => esc_html__( 'Quote', 'huber-plugin' ),
						'description' => esc_html__( 'The testimonial quote.', 'huber-plugin' ),
						'param_name' => 'content',
						'value' => '',
						'type' => 'textarea',
						),		
						array( 
						'heading' => esc_html__( 'Name', 'huber-plugin' ),
						'description' => esc_html__( 'The name of the person who gave the testimonial.', 'huber-plugin' ),
						'param_name' => 'name',
						'value' => '',
						'type' => 'textfield',
						),																																							
					 )
				 ) );																																

			}

		}
	
	}	

}

?>